/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// PrintOpt.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "BSch.h"
#include "PrintOpt.h"
#include ".\printopt.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CPrintOpt _CAO


CPrintOpt::CPrintOpt(CWnd* pParent /*=NULL*/)
	: CDialog(CPrintOpt::IDD, pParent)

{
	//{{AFX_DATA_INIT(CPrintOpt)
	m_bFrame = TRUE;
	m_bPartNum = TRUE;
	m_bPartName = FALSE;
	m_bPrintBmp = FALSE;
	m_bPrintColor = FALSE;
	//}}AFX_DATA_INIT

	m_bPageFit = FALSE;

	m_nPrintRes = 0;
	m_nLeftMargin	=0;
	m_nRightMargin	=0;
	m_nUpperMargin	=0;
	m_nLowerMargin	=0;

	//m_nDefaultRes = 200;
}


void CPrintOpt::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPrintOpt)
	DDX_Check(pDX, IDC_CHECK_FRAME, m_bFrame);
	DDX_Check(pDX, IDC_CHECK_PARTNUM, m_bPartNum);
	DDX_Check(pDX, IDC_CHECK_PARTNAME, m_bPartName);
	DDX_Check(pDX, IDC_CHECK_PRINTBMP,m_bPrintBmp);
	//}}AFX_DATA_MAP
	DDX_Check(pDX, IDC_CHECK_PRINT_COLOR, m_bPrintColor);
}


BEGIN_MESSAGE_MAP(CPrintOpt, CDialog)
	//{{AFX_MSG_MAP(CPrintOpt)
//	ON_BN_CLICKED(IDC_CHECK_RES_AUTO, OnCheckResAuto)
	//}}AFX_MSG_MAP
//	ON_BN_CLICKED(IDC_CHECK_PRINT_COLOR, OnBnClickedCheckPrintColor)
ON_BN_CLICKED(IDC_CHECK_PRINTBMP, OnBnClickedCheckPrintbmp)
ON_BN_CLICKED(IDC_CHECK_PAGEFIT, OnBnClickedCheckPagefit)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CPrintOpt bZ[W nh

BOOL CPrintOpt::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	CButton* pCheck=(CButton*)GetDlgItem(IDC_CHECK_PAGEFIT);
	CEdit*   pEdit =(CEdit*)GetDlgItem(IDC_EDIT_RES);
	pEdit->SetLimitText(3);
	if(m_bPageFit){
		pCheck->SetCheck(1);
		pEdit->EnableWindow(FALSE);
		SetDlgItemText(IDC_EDIT_RES,"");
	}else{
		pCheck->SetCheck(0);
		pEdit->EnableWindow(TRUE);
		SetDlgItemInt(IDC_EDIT_RES,m_nPrintRes,FALSE);
	}

	SetDlgItemInt(IDC_EDIT_LEFT_M,m_nLeftMargin,FALSE);
	SetDlgItemInt(IDC_EDIT_RIGHT_M,m_nRightMargin,FALSE);
	SetDlgItemInt(IDC_EDIT_UPPER_M,m_nUpperMargin,FALSE);
	SetDlgItemInt(IDC_EDIT_LOWER_M,m_nLowerMargin,FALSE);

	pCheck=(CButton*)GetDlgItem(IDC_CHECK_PRINTBMP);
	if(pCheck->GetCheck()){
		pCheck=(CButton*)GetDlgItem(IDC_CHECK_PRINT_COLOR);
		pCheck->SetCheck(0);
		pCheck->EnableWindow(FALSE);
	}

	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

//void CPrintOpt::OnCheckResAuto() 
//{
//	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
//	CButton* pCheck=(CButton*)GetDlgItem(IDC_CHECK_RES_AUTO);
//	CEdit*   pEdit =(CEdit*)GetDlgItem(IDC_EDIT_RES);
//	if(pCheck->GetCheck()){
//		pCheck->SetCheck(0);
//		pEdit->EnableWindow(TRUE);
//	}else{
//		pCheck->SetCheck(1);
//		SetDlgItemInt(IDC_EDIT_RES,m_nDefaultRes,FALSE);
//		pEdit->EnableWindow(FALSE);
//	}
//}

void CPrintOpt::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	CButton* pCheck=(CButton*)GetDlgItem(IDC_CHECK_PAGEFIT);
	CEdit*   pEdit =(CEdit*)GetDlgItem(IDC_EDIT_RES);

	m_bPageFit=pCheck->GetCheck();
	m_nPrintRes=GetDlgItemInt(IDC_EDIT_RES,NULL,FALSE);

	if(m_bPageFit){
		m_nPrintRes = 100;
	}else{
		if(m_nPrintRes<30 || m_nPrintRes>300){
			AfxMessageBox(IDS_INVALID_RESOLUTION,MB_ICONEXCLAMATION|MB_OK);
			return;
		}
	}

	BOOL bTrans=TRUE;
	BOOL bTransResult;
	m_nLeftMargin=GetDlgItemInt(IDC_EDIT_LEFT_M,&bTransResult,FALSE);
	bTrans &= bTransResult;
	m_nRightMargin=GetDlgItemInt(IDC_EDIT_RIGHT_M,&bTransResult,FALSE);
	bTrans &= bTransResult;
	m_nUpperMargin=GetDlgItemInt(IDC_EDIT_UPPER_M,&bTransResult,FALSE);
	bTrans &= bTransResult;
	m_nLowerMargin=GetDlgItemInt(IDC_EDIT_LOWER_M,&bTransResult,FALSE);
	bTrans &= bTransResult;
	if(		!bTrans
		||	m_nLeftMargin>100
		||	m_nRightMargin>100
		||	m_nUpperMargin>100
		||	m_nLowerMargin>100){
		AfxMessageBox(IDS_INVALID_MARGIN,MB_ICONEXCLAMATION|MB_OK);
		return;
	}
		

	CDialog::OnOK();
}

void CPrintOpt::OnBnClickedCheckPrintbmp()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CButton* pCheckBmp=(CButton*)GetDlgItem(IDC_CHECK_PRINTBMP);
	CButton* pCheckCol=(CButton*)GetDlgItem(IDC_CHECK_PRINT_COLOR);
	if(pCheckBmp->GetCheck()){
		pCheckCol->SetCheck(0);
		pCheckCol->EnableWindow(FALSE);
	}else{
		pCheckCol->EnableWindow(TRUE);
	}
}

void CPrintOpt::OnBnClickedCheckPagefit()
{
	// TODO : ɃRg[ʒmnh R[hǉ܂B
	CButton* pCheck=(CButton*)GetDlgItem(IDC_CHECK_PAGEFIT);
	CEdit*   pEdit =(CEdit*)GetDlgItem(IDC_EDIT_RES);

	if(pCheck->GetCheck()){
		m_nPrintRes=GetDlgItemInt(IDC_EDIT_RES,NULL,FALSE);
		SetDlgItemText(IDC_EDIT_RES,"");
		pEdit->EnableWindow(FALSE);
	}else{
		pEdit->EnableWindow(TRUE);
		SetDlgItemInt(IDC_EDIT_RES,m_nPrintRes);
	}
}
