/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** }[NAbvNX
****************************************************************************/
#ifndef SMARKUPTEXTLINE_H
#define SMARKUPTEXTLINE_H

#include <list>
#include <stack>
using namespace std;

class SMarkupTextLine
{
public:
	SMarkupTextLine(void);
	~SMarkupTextLine(void);

	enum TEXT_STYLE
	{ 
		NO_STYLE	= 0,
		FONT_NAME	= 0x0001,
		OVERBAR		= 0x0002,
		UNDERLINE	= 0x0004,
		BOLD		= 0x0008,
		ITALIC		= 0x0010,
		SUB			= 0x0020,
		SUP			= 0x0040,
		CR			= 0x8000	//ŉsB
	};

	enum CHAR_PROPERTY
	{
		NO_CHAR_PROPERTY = 0,
		BREAKABLE   	 = 1,		//̑̕Oŉs\
		BREAKLINE		 = 2    	//̕őOŉs
	};

	string	m_strText;
	string	m_fontName;
	unsigned int m_textSyle;
	unsigned int *m_charFlags;
};

typedef list<SMarkupTextLine*> MarkupTextLineList;
typedef list<SMarkupTextLine*>::iterator MarkupTextLineIterator;

void g_CreateMarkupTextLines(const char* src,MarkupTextLineList* pMarkupTextLineList);



#endif