/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

#include "stdafx.h"
#include "coord.h"
#include "coord2.h"

CSize SSize2CSize(const SSize& ssize)
{
	return CSize(ssize.w(),ssize.h());
}

SSize CSize2SSize(const CSize& csize)
{
	return SSize(csize.cx,csize.cy);
}

CPoint SPoint2CPoint(const SPoint& spoint)
{
	return CPoint(spoint.x(),spoint.y());
}

SPoint CPoint2SPoint(const CPoint& cpoint)
{
	return SPoint(cpoint.x,cpoint.y);
}

CRect SRect2CRect(const SRect& srect)
{
	return CRect(srect.l(),srect.t(),srect.r(),srect.b());
}

SRect CRect2SRect(const CRect& crect)
{
	return SRect(crect.left,crect.top,crect.Width(),crect.Height());
}
