/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2006 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSch}ʗvfNX
****************************************************************************/
#ifndef XBSCHLINE_H
#define XBSCHLINE_H

#include "xbsch.h"
#include "xbschobj.h"
//#include <SPoint.h>
//#include <SRect.h>

class SXBSchLine:public SXBSchObj
{
public:
	//RXgN^
	SXBSchLine();
	//fXgN^
	virtual ~SXBSchLine(){}
	//IԂ̂Ƃ̃Xibv|Cg擾
	SPoint snapPoint();

public:
	//_w肵đIdvxԂ
	int qSelectWeight(const SPoint&);
	//͈͂w肵đIs
	unsigned testSelection(const SRect& );
	//͈͂IăhbOIs
	unsigned testSelectionForDrag(const SRect& );
	//`悪KvǂԂ
	bool qRedraw(const SRect& );
	//sԂ
	//int pinCount(){return 2;}
	//nԖڂ̃s̈ʒu𓾂B
	//SPoint pinPosition(int);
	SRect area();
	SRect rotateRect();
	//LȃIuWFNgȂtrueԂB̂Ȃ͗Lł͂ȂB
	bool qValid(){return(m_p1 != m_p2);}

	bool isHorizontal(){return (m_p1.y() == m_p2.y());}	//2008/06/26
	bool isVertical(){return (m_p1.x() == m_p2.x());}	//2008/06/26

		//PƑÎƂɃ~[\ǂԂ
	bool canMirrorSingleSelected() {return (!isHorizontal() && !isVertical()); }//2008/06/26

	//XWw肵čE]s
	void mirrorH(int x);
	//E]s
	void mirrorH();
	//XYSWw肵āA]s
	void rotate(const SPoint& p);
	//]s
	void rotate();

protected:
	//Xg[̓ǂݍ
	//bool readStreamEx(SCsvIStream* pStrm,const SPoint* pptOrigin,const char* pTag);
	//Xg[ւ̏
	//bool writeStreamEx(SCsvOStream* pStrm,const SPoint* pptOrigin,const char* pTag);

	//Xg[̓ǂݍ
	virtual bool readCe3Ex(SReadCE3& rce3,const SPoint* pptOrigin,const char* pTag);
	//Xg[ւ̏
	virtual bool writeCe3Ex(SWriteCE3& wce3,const SPoint* pptOrigin,const char* pTag);

};

//C[NX
class SXBSchWire:public SXBSchLine
{
public:
	//RXgN^
	SXBSchWire(){}
	//fXgN^
	~SXBSchWire(){}
/*
	//Xg[̓ǂݍ ` -WIRE
	bool readStream(SCsvIStream* pStrm,const SPoint* pptOrigin);
	//Xg[ւ̏݁@+WIRE ` -WIRE
	bool writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin);
*/
	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

	//ID̎擾
	unsigned id(){return ID_WIRE;}
	unsigned objectFilterValue(){return OBJMASK_WIRE;} 
	//s
	SXBSchObj* duplicate();
};

//oXNX
class SXBSchBus:public SXBSchLine
{
public:
	//RXgN^
	SXBSchBus(){}
	//fXgN^
	~SXBSchBus(){}
	//ID̎擾
	unsigned id(){return ID_BUS;}
	unsigned objectFilterValue(){return OBJMASK_BUS;}
/*
	//Xg[̓ǂݍ ` -BUS
	bool readStream(SCsvIStream* pStrm,const SPoint* pptOrigin);
	//Xg[ւ̏݁@+BUS ` -BUS
	bool writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin);
*/
	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

	//s
	SXBSchObj* duplicate();
};

//jNX
class SXBSchDash:public SXBSchLine
{
public:
	//RXgN^
	SXBSchDash(){}
	//fXgN^
	~SXBSchDash(){}

/*
	//Xg[̓ǂݍ ` -DASH
	bool readStream(SCsvIStream* pStrm,const SPoint* pptOrigin);
	//Xg[ւ̏݁@+DASH ` -DASH
	bool writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin);
*/
	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

	
	//ID̎擾
	unsigned id(){return ID_DASH;}
	unsigned objectFilterValue(){return OBJMASK_DASH;} 
	//s
	SXBSchObj* duplicate();



};

//#define MIN_MARKER_WIDTH 3
//#define MAX_MARKER_WIDTH 101


//jNX
class SXBSchMarkerLine:public SXBSchLine
{
public:

	static const unsigned int DEFAULT_COLOR = 8454016;
	static const int MIN_MARKER_WIDTH = 3;
	static const int DEFAULT_MARKER_WIDTH = 7;
	static const int MAX_MARKER_WIDTH = 100;


	//RXgN^
	SXBSchMarkerLine(){
		m_width = DEFAULT_MARKER_WIDTH;
		m_nColor = DEFAULT_COLOR;
	}
	//fXgN^
	~SXBSchMarkerLine(){}

	//͈͂w肵đIs
	unsigned testSelection(const SRect& );
	//͈͂IăhbOIs
	unsigned testSelectionForDrag(const SRect& );


	
/*
	//Xg[̓ǂݍ ` -DASH
	bool readStream(SCsvIStream* pStrm,const SPoint* pptOrigin);
	//Xg[ւ̏݁@+DASH ` -DASH
	bool writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin);
*/
	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

	//}[J[C̊O`4̃|Cg̍W𓾂
	void outlinePoint(SPoint*);

	SRect area();

	//Agr[g̕ύX\ȏꍇtrueԂB
	bool canAttribute() {return true;}

	bool pointIsInside(const SPoint& ,const SPoint* );

	
	//ID̎擾
	unsigned id(){return ID_MARKER;}
	unsigned objectFilterValue(){return OBJMASK_MARKER;} 
	//s
	SXBSchObj* duplicate();

	int m_width;
	unsigned int m_nColor;
};



#endif
