/****************************************************************************
    BSch3V schematic capture
    Copyright (C) 1997-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// Print.cpp : CBSchView NX̂v^֘A̓̒`s܂B

#include "stdafx.h"
#include <stdlib.h> //_splitpath()̂߂ɃCN[h
#include "BSch.h"
#include <assert.h>
#include <string>
#include <list>
using namespace std;
#include <atlimage.h>	//CImagê߂̃CN[hBGDIPLUS.DLL̓JwŁAx[hw邱ƁB



//#include "SetLib.h"

//#include "BSchObj.h"

#include "BSchDoc.h"
#include "BSchView.h"
#include "MainFrm.h"

//#include "PartLib.h"
//#include "BSchFont.h"
#include "Global.h"
#include "PrintOpt.h"	//bdl̈IvVݒ_CAO
//#include "BSchPart.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define PRINT_OVERLAP 24
//#define BMP_BANDSIZE  500
/////////////////////////////////////////////////////////////////////////////
// CBSchView NẌ

BOOL CBSchView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg̈
	return DoPreparePrinting(pInfo);
}

void CBSchView::OnBeginPrinting(CDC* pDC , CPrintInfo* pInfo)
{
	// TODO: O̓ʂȏǉĂB
	TRACE("\nTRACE:OnBeginPrinting()");
	int nRes;
	nRes=IniReadPrintRes();
	nRes=15000/nRes;
	//if(nRes==0){
	//	nRes=GetDefaultPrintRes(pDC);
	//}
    m_bPrintPageFit =IniReadPrintPageFit();
		
	SetPageSize(pDC,nRes);
	int nCountPage=GetCountPage();
	pInfo->SetMaxPage(nCountPage);
}


void CBSchView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
	TRACE("\nTRACE:OnEndPrinting()");
}

//̂߂̕`tȌ
//	1997/01/28V
void CBSchView::PrepareDrawFlagForPrint(CDC* pDC)
{
	TRACE("TRACE:PrepareDrawFlagForPrint()\n");

	int nPrintRes=IniReadPrintRes();
	nPrintRes=15000/nPrintRes;

	//if(nPrintRes==0 && pDC!=NULL){
	//	nPrintRes=GetDefaultPrintRes(pDC);
	//}

	//m_bPrintPageFit =IniReadPrintPageFit();


	//p̐ݒ
	if(pDC){
		if(m_bPrintPageFit){
			double dmx=(double)m_sizePageDevicePixel.cx/m_sizePrintPixel.cx;
			double dmy=(double)m_sizePageDevicePixel.cy/m_sizePrintPixel.cy;
			double dm=(dmx<dmy ? dmx : dmy);
			m_nPrintVExt=(int)(dm*1000);
			m_nPrintWExt=1000;
		}else{
			int nDpi=pDC->GetDeviceCaps(LOGPIXELSX);
			m_nPrintVExt = nDpi;
			m_nPrintWExt = nPrintRes;
		}
	}else{
		m_nPrintVExt=1;
		m_nPrintWExt=1;
	}
	m_bPrintFrame	=AfxGetApp()->GetProfileInt("Option","PrintSheetFrame",TRUE);
	m_bBitmapPrint	=AfxGetApp()->GetProfileInt("Option","PrintBitmap",FALSE);
	m_bPrintColor	=AfxGetApp()->GetProfileInt("Option","PrintColor",FALSE);
	
}

//OPrepareDrawFlagForPrint()ő삵`tOɖ߂	
void CBSchView::PopDrawFlagForPrint()
{
}


//W̉𑜓x𓾂 1998/07/04
int CBSchView::GetDefaultPrintRes(CDC* pDC)
{
	int nDpi,nDpiY;
	//𑜓x𓾂
	nDpi=pDC->GetDeviceCaps(LOGPIXELSX);
	nDpiY=pDC->GetDeviceCaps(LOGPIXELSX);
	if(nDpi>nDpiY)nDpi=nDpiY;
	int mul=nDpi/150;
	if(mul==0) mul+=1;
	return nDpi/mul;
}

//y[W̊eW߂
void CBSchView::SetPageSize(CDC* pDC,int nRes)
{
	int nX,nY;
	int nDpiX,nDpiY;
//	int nMarginX;
//	int nMarginY;

	
	//sNZƉ𑜓x𓾂
	nX   =pDC->GetDeviceCaps(HORZRES);
	nY   =pDC->GetDeviceCaps(VERTRES);
	nDpiX=pDC->GetDeviceCaps(LOGPIXELSX);
	nDpiY=pDC->GetDeviceCaps(LOGPIXELSX);
	int px=pDC->GetDeviceCaps(PHYSICALOFFSETX);
	int py=pDC->GetDeviceCaps(PHYSICALOFFSETY);
	int pw=pDC->GetDeviceCaps(PHYSICALWIDTH);
	int ph=pDC->GetDeviceCaps(PHYSICALHEIGHT);


	TRACE("HORZRES,VERTRES : %d,%d\n",nX,nY);
	TRACE("LOGPIXELSX,LOGPIXELSX : %d,%d\n",nDpiX,nDpiY);
	TRACE("PHYSICALOFFSETX,PHYSICALOFFSETY : %d,%d\n",px,py);
	TRACE("PHYSICALWIDTH,PHYSICALHEIGHT : %d,%d\n",pw,ph);

	//    2005/09/11ǉ>>>>>>
	int left,upper,right,lower;
	IniReadPrintMargin(left,upper,right,lower);

	left  = left  * nDpiX * 10 /254;
	right = right * nDpiX * 10 /254;
	upper = upper * nDpiY * 10 /254;
	lower = lower * nDpiY * 10 /254;

	left -= px;
	if(left<0) left=0;
	upper -= py;
	if(upper<0) upper=0;

	int physicalRightMargin=pw-(px+nX);
	if(physicalRightMargin<0) physicalRightMargin=0;

	int physicalLowerMargin=ph-(py+nY);
	if(physicalLowerMargin<0) physicalLowerMargin=0;

	right -= physicalRightMargin;
	if(right<0) right=0;

	lower -= physicalLowerMargin;
	if(lower<0) lower=0;

	if((left+right)>(nX/2)){
		left=right=0;
	}

	if((upper+lower)>(nY/2)){
		upper=lower=0;
	}


	//̍̃sNŽ
	m_pointPageLT.x=left;
	m_pointPageLT.y=upper;
	m_sizePageDevicePixel.cx=nX-(left+right);
	m_sizePageDevicePixel.cy=nY-(upper+lower);

	//Py[Wɏo͉\Ȑ}ʏł̃TCY̌
	if(m_bPrintPageFit){
		CBSchDoc* pDoc = GetDocument();
		m_sizePrintPixel=pDoc->GetSheetSize();	//}ʃTCY𓾂
	}else{
		m_sizePrintPixel.cx=m_sizePageDevicePixel.cx*nRes/nDpiX;
		m_sizePrintPixel.cy=m_sizePageDevicePixel.cy*nRes/nDpiY;
	}
}

//y[W𓾂
int CBSchView::GetCountPage()
{
	m_nPageX=1;
	m_nPageY=1;

	if(m_bPrintPageFit)return 1;

	int n,m;
	CBSchDoc* pDoc = GetDocument();
	CSize size;
	size=pDoc->GetSheetSize();	//}ʃTCY𓾂
	n=size.cx-m_sizePrintPixel.cx;
	if(n>0){
		m=m_sizePrintPixel.cx-PRINT_OVERLAP;
		m_nPageX+=(n+(m-1))/m;
	}
	n=size.cy-m_sizePrintPixel.cy;
	if(n>0){
		m=m_sizePrintPixel.cy-PRINT_OVERLAP;
		m_nPageY+=(n+(m-1))/m;
	}
	return m_nPageX*m_nPageY;
}


void CBSchView::OnFilePrint() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	ChangeTool(m_nCurrentTool,m_nCurrentTool);
//	CScrollView::OnFilePrint();
	((CBSchApp*)AfxGetApp())->UpdatePrinterSelection(FALSE);
	CScrollView::OnFilePrint();
	((CBSchApp*)AfxGetApp())->IniWritePrinterSetup();
}

void CBSchView::OnFilePrintPreview() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	ChangeTool(m_nCurrentTool,m_nCurrentTool);
	((CBSchApp*)AfxGetApp())->UpdatePrinterSelection(FALSE);
	CScrollView::OnFilePrintPreview();
}

/////////////////////////////////////////////////////////////
//   y[W̎
// PDy[WԍƂɃy[WɈ`͈͂𓾂
// QDPœ`͈͑̃mNrbg}bv쐬
// RDʂƃRp`ȃfoCXReLXg쐬
//      (v^ƃRp`Ɖ̂`悪łȂƂ)
// SDfoCXReLXgɂQō쐬rbg}bvI
// TDfoCXReLXgWindowOrgړ
// UD`
// VDfoCXReLXgWindowOrg(0,0)ɖ߂
void CBSchView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	
	CPoint pointOrigin;
	CSize sizePage;
	CSize sizeSheet;

	PrepareDrawFlagForPrint(pDC); // 1997/01/28

	int nPage=pInfo->m_nCurPage-1;	//y[W
	pointOrigin.y=(m_sizePrintPixel.cy-PRINT_OVERLAP)*(nPage/m_nPageX);
	pointOrigin.x=(m_sizePrintPixel.cx-PRINT_OVERLAP)*(nPage%m_nPageX);

	CBSchDoc* pDoc = GetDocument();
	sizeSheet=pDoc->GetSheetSize();	//}ʃTCY𓾂
	if((pointOrigin.x+m_sizePrintPixel.cx)>sizeSheet.cx){
		sizePage.cx=sizeSheet.cx-pointOrigin.x;
	}else{
		sizePage.cx=m_sizePrintPixel.cx;
	}
	if((pointOrigin.y+m_sizePrintPixel.cy)>sizeSheet.cy){
		sizePage.cy=sizeSheet.cy-pointOrigin.y;
	}else{
		sizePage.cy=m_sizePrintPixel.cy;
	}

//	DWORD dwMode = (m_bPrintColor ? DRAW_ON : DRAW_OFF);
	DWORD dwMode;
	if(m_bPrintColor){	// && m_COL_BG==RGB(255,255,255)){
		dwMode = DRAW_ON;
	}else{
		dwMode = DRAW_OFF;
	}

	if(g_bDisplayNcPinMark)dwMode|=DRAW_NC_MARK;

	if(!m_bBitmapPrint){
		//pDC->SetTextColor(RGB(0,0,0));
		//pDC->SetBkColor(RGB(255,255,255));
		int printX1,printY1,printX2,printY2;
		printX1 = pointOrigin.x*m_nPrintVExt/m_nPrintWExt;
		printY1 = pointOrigin.y*m_nPrintVExt/m_nPrintWExt;
		printX2	= sizePage.cx*m_nPrintVExt/m_nPrintWExt+printX1;
		printY2	= sizePage.cy*m_nPrintVExt/m_nPrintWExt+printY1;

		pDC->SetWindowOrg(printX1-m_pointPageLT.x,printY1-m_pointPageLT.y);

		pDC->SelectClipRgn(NULL);

		int frameWidth = (m_nPrintVExt/m_nPrintWExt)/2;

		pDC->IntersectClipRect(printX1-frameWidth,printY1-frameWidth,
							   printX2+frameWidth,printY2+frameWidth);

		CRect rcClip=CRect( pointOrigin.x,pointOrigin.y,
						pointOrigin.x+sizePage.cx,pointOrigin.y+sizePage.cy);

		
		//Version 0.63 ̔wiF
		if(m_bPrintColor && m_COL.colBG!=RGB(255,255,255) ){
			if(AfxGetApp()->GetProfileInt("Option","PrintBgWhite",1)!=1){
				DrawPrintBg(pDC,dwMode,m_nPrintVExt,m_nPrintWExt,NULL);
			}
		}


		if(m_bPrintFrame){	
			DrawSheetFrame(pDC,dwMode,m_nPrintVExt,m_nPrintWExt,rcClip);
		}
		//DWORD dwMode = DRAW_OFF;
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartNum",TRUE)){
			dwMode |= DRAW_INH_PARTNUM;
		}
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartName",TRUE)){
			dwMode |= DRAW_INH_PARTNAME;
		}
		dwMode |= DRAW_FOR_PRINT;
		DrawMainData(pDC,pDoc,dwMode,m_nPrintVExt,m_nPrintWExt,rcClip);
	}else{
		
		int drawOrgX		= pointOrigin.x*2;
		int drawOrgY		= pointOrigin.y*2;
		int drawSizeWidth	= sizePage.cx*2;
		int drawSizeHeight	= sizePage.cy*2;

		CBitmap bmp;
		CBitmap* pOldBmp;
		//`pfoCXReLXg̍쐬
		CClientDC dc(this);	
		CDC dcMem;						
		dcMem.CreateCompatibleDC(&dc);
		bmp.CreateBitmap(drawSizeWidth,drawSizeHeight,1,1,NULL);
		pOldBmp=dcMem.SelectObject(&bmp);
		COLORREF colBk=dcMem.GetBkColor();//ŏ
		dcMem.FillSolidRect(0,0,drawSizeWidth,drawSizeHeight,RGB(255,255,255));
		dcMem.SetBkColor(colBk);
		dcMem.SetWindowOrg(drawOrgX,drawOrgY);		//̘_Wݒ
		CRect rcClip=CRect( pointOrigin.x,pointOrigin.y,
						pointOrigin.x+sizePage.cx, pointOrigin.y+sizePage.cy);
		//ۂ̕`
		if(m_bPrintFrame)	DrawSheetFrame(&dcMem,DRAW_OFF,2,1,rcClip);
		dwMode = DRAW_OFF;
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartNum",TRUE)){
			dwMode |= DRAW_INH_PARTNUM;
		}
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartName",TRUE)){
			dwMode |= DRAW_INH_PARTNAME;
		}
		dwMode |= DRAW_FOR_PRINT;
		DrawMainData(&dcMem,pDoc,dwMode,2,1,rcClip);
		//v^ւ̓]
		dcMem.SetWindowOrg(0,0);
		pDC->SetTextColor(RGB(0,0,0));		//1997/11/13
		pDC->SetBkColor(RGB(255,255,255));	//1997/11/13
		pDC->StretchBlt(m_pointPageLT.x,m_pointPageLT.y,
						sizePage.cx*m_nPrintVExt/m_nPrintWExt,
						sizePage.cy*m_nPrintVExt/m_nPrintWExt,
//						sizePage.cx*m_nPrintMagX/m_nPrintMagX2,
//						sizePage.cy*m_nPrintMagY/m_nPrintMagY2,
						&dcMem,
						0,0,
						drawSizeWidth,drawSizeHeight,
						SRCCOPY);
		dcMem.SelectObject(pOldBmp);
		//dcdcMembmp̍폜͎IɍsA͂B
	}

	PopDrawFlagForPrint();	// 1997/01/28

}

void CBSchView::OnFileExpoEmf()
{
	// TODO : ɃR}h nh R[hǉ܂B
	//ꎞf[^΁AGNX|[gOɃtBbNX
	ChangeTool(m_nCurrentTool,m_nCurrentTool);

	//݂̃t@C̖O𓾂
	CBSchDoc* pDoc = GetDocument();
	CString rTitle=pDoc->GetTitle();
	char szName[_MAX_FNAME];
	::_splitpath(rTitle,NULL,NULL,szName,NULL);

	//t@C_CAONăt@C߂
	CString rCaption;
	CFileDialog dlg(FALSE,				//ۑ_CAO
					"emf",				//gqtȂꍇ̃ftHg
					szName,				//t@C
					OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
					"Meta file(*.emf)|*.EMF||",	//tB^
					this);				//eEChE
	rCaption.LoadString(IDS_FNAME_EXPO_EMF);//_CAO{bNX̃LvV\[X烍[h
	dlg.m_ofn.lpstrTitle=rCaption;		//t@C_CAONXɃLvV̐ݒ
	if(dlg.DoModal()==IDOK){			//t@C_CAO̎s
		CString emfName=CString(dlg.m_ofn.lpstrFile);		//t@C_CAOt@C擾

		PrepareDrawFlagForPrint(NULL);

		HCURSOR hCursor;
		hCursor=AfxGetApp()->LoadStandardCursor(IDC_WAIT);//vJ[\
		hCursor=::SetCursor(hCursor);
		if(!ExportEmf(emfName)){
			::SetCursor(hCursor);
			AfxMessageBox(IDS_EXPO_EMF_ERROR,MB_OK|MB_ICONEXCLAMATION);
		}else{
			::SetCursor(hCursor);
		}
		PopDrawFlagForPrint();
	}


}

/////////////////////////////////////////////////////////
//rbg}bvt@CExportR}hnh
void CBSchView::OnFileExpoBmp() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ


	//0.64.03ŁAGDIPLUS.DLLgƂ́ACImagegPNGGIFŕۑł悤ɂB
	CString strFilter;
	if(g_bAvailableGDIplus){
		strFilter = "Bitmap file(*.bmp)|*.BMP|PNG file(*.png)|*.PNG||";
	}else{
		strFilter = "Bitmap file(*.bmp)|*.BMP||";
	}


	//ꎞf[^΁AGNX|[gOɃtBbNX
	ChangeTool(m_nCurrentTool,m_nCurrentTool);

	//݂̃t@C̖O𓾂
	CBSchDoc* pDoc = GetDocument();
	CString rTitle=pDoc->GetTitle();
	char szName[_MAX_FNAME];
	::_splitpath(rTitle,NULL,NULL,szName,NULL);

	//t@C_CAONăt@C߂
	CString rCaption;
	CFileDialog dlg(FALSE,				//ۑ_CAO
					"bmp",				//gqtȂꍇ̃ftHg
					szName,				//t@C
					OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
					strFilter,	//tB^
					this);				//eEChE
	rCaption.LoadString(IDS_FNAME_EXPO_BMP);//_CAO{bNX̃LvV\[X烍[h
	dlg.m_ofn.lpstrTitle=rCaption;		//t@C_CAONXɃLvV̐ݒ
	if(dlg.DoModal()==IDOK){			//t@C_CAO̎s
		CString rBmpName=CString(dlg.m_ofn.lpstrFile);		//t@C_CAOt@C擾
		TRACE("\nrBmpName=%s",(const char*)rBmpName);

		PrepareDrawFlagForPrint(NULL); // 1997/01/28
		HCURSOR hCursor;
		hCursor=AfxGetApp()->LoadStandardCursor(IDC_WAIT);//vJ[\
		hCursor=::SetCursor(hCursor);
		if(!ExportBitmapFile(rBmpName)){
			::SetCursor(hCursor);
			AfxMessageBox(IDS_EXPO_BMP_ERROR,MB_OK|MB_ICONEXCLAMATION);
		}else{
			::SetCursor(hCursor);
		}
		PopDrawFlagForPrint();
	}
}


BOOL CBSchView::ExportBitmapFile(LPCSTR pszFileName)
{
	BOOL bColorMode = AfxGetApp()->GetProfileInt("Option","PrintColor",FALSE);
	BOOL bPrintBgWhite = AfxGetApp()->GetProfileInt("Option","PrintBgWhite",1);


	bool bUseImage = true;

	if(!g_bAvailableGDIplus){
		bUseImage = false;
	}else{
		char szExtension[_MAX_EXT];
		::_splitpath(pszFileName,NULL,NULL,NULL,szExtension);
		if(stricmp(szExtension,".bmp")==0){
			if(bColorMode == FALSE){
				bUseImage = false;
			}
		}
	}

	if(bUseImage){
		CSize sizeSheet;
		CBSchDoc* pDoc = GetDocument();
		sizeSheet=pDoc->GetSheetSize();

		CImage image;
		image.Create(sizeSheet.cx,sizeSheet.cy,24);

		HDC hdc = image.GetDC();
		CDC* pdc = CDC::FromHandle(hdc);

		CRect rcClip=CRect(0,0,sizeSheet.cx,sizeSheet.cy);
		pdc->SetWindowOrg(0,0);



		COLORREF colBk=pdc->GetBkColor();
		COLORREF colbg;
		if(bColorMode && !bPrintBgWhite){
			colbg = m_COL.colBG;
		}else{
			colbg = RGB(255,255,255);
		}

		pdc->FillSolidRect(0,0,sizeSheet.cx,sizeSheet.cy,colbg);
		//pdc->SetBkColor(colBk);
		pdc->SetWindowOrg(0,0);

		DWORD dwMode = (bColorMode ? DRAW_ON : DRAW_OFF);

		//ۂ̕`
		if(m_bPrintFrame) DrawSheetFrame(pdc,dwMode,m_nPrintVExt,m_nPrintWExt,rcClip);

		//DWORD dwMode = DRAW_OFF;
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartNum",TRUE)){
			dwMode |= DRAW_INH_PARTNUM;
		}
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartName",TRUE)){
			dwMode |= DRAW_INH_PARTNAME;
		}
		dwMode |= DRAW_FOR_PRINT;
		if(g_bDisplayNcPinMark)dwMode|=DRAW_NC_MARK;
		DrawMainData(pdc,pDoc,dwMode,m_nPrintVExt,m_nPrintWExt,rcClip);

		image.Save(pszFileName);
		
		image.ReleaseDC();
		return TRUE;
	}else{


		CSize sizeSheet;
		CBSchDoc* pDoc = GetDocument();
		sizeSheet=pDoc->GetSheetSize();

		int nBmpXbyte;	//foCXˑ̃rbg}bv̐oCg
		int nBmpSize;	//foCXˑ̃rbg}bṽTCY
		int nDibXbyte;	//foCXƗ̃rbg}bv̐oCg
		int nDibSize;	//foCXˑ̃rbg}bṽTCY

		nBmpXbyte=((sizeSheet.cx+15)/16)*2;
		nBmpSize=nBmpXbyte*sizeSheet.cy;
		nDibXbyte=((sizeSheet.cx+31)/32)*4;
		nDibSize=nDibXbyte*sizeSheet.cy;


		/////////////////////////////////////
		//BITMAPINFO
		int headersize = sizeof(BITMAPINFOHEADER)+sizeof(RGBQUAD)*2;
		BYTE* pbihBuff = new BYTE[headersize];
		BITMAPINFO* pbih =(BITMAPINFO*) pbihBuff;
		pbih->bmiHeader.biSize=sizeof(BITMAPINFOHEADER);
		pbih->bmiHeader.biWidth =sizeSheet.cx;
		pbih->bmiHeader.biHeight=sizeSheet.cy;
		pbih->bmiHeader.biPlanes=1;
		pbih->bmiHeader.biBitCount=1;
		pbih->bmiHeader.biCompression=0;
		pbih->bmiHeader.biSizeImage=nDibSize;
		pbih->bmiHeader.biXPelsPerMeter=5906;	//150dpi
		pbih->bmiHeader.biYPelsPerMeter=5906;	//150dpi
		pbih->bmiHeader.biClrUsed=0;
		pbih->bmiHeader.biClrImportant=0;


		//`pfoCXReLXg̍쐬
		CClientDC dc(this);
		CDC dcMem;
		dcMem.CreateCompatibleDC(&dc);
		//rbg}bv̍쐬
		CBitmap bmp;
		CBitmap* pOldBmp;
		//if(!bmp.CreateCompatibleBitmap(&dcMem,sizeSheet.cx,sizeSheet.cy))return FALSE;
		if(!bmp.CreateBitmap(sizeSheet.cx,sizeSheet.cy,1,1,NULL))return FALSE;

		//rbg}bvrbgۑp̃obt@
		int bitBuffSize = nBmpXbyte*sizeSheet.cy;
		BYTE* bitbuff=new BYTE[nDibSize];
		if(!bitbuff) return FALSE;


		CRect rcClip=CRect(0,0,sizeSheet.cx,sizeSheet.cy);

		pOldBmp=dcMem.SelectObject(&bmp);
		dcMem.SetWindowOrg(0,0);

		//ŏ
		COLORREF colBk=dcMem.GetBkColor();
		dcMem.FillSolidRect(0,0,sizeSheet.cx,sizeSheet.cy,RGB(255,255,255));
		dcMem.SetBkColor(colBk);
		dcMem.SetWindowOrg(0,0);
		//ۂ̕`
		if(m_bPrintFrame) DrawSheetFrame(&dcMem,DRAW_OFF,m_nPrintVExt,m_nPrintWExt,rcClip);

		DWORD dwMode = DRAW_OFF;
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartNum",TRUE)){
			dwMode |= DRAW_INH_PARTNUM;
		}
		if(!AfxGetApp()->GetProfileInt("Option","PrintPartName",TRUE)){
			dwMode |= DRAW_INH_PARTNAME;
		}
		dwMode |= DRAW_FOR_PRINT;
		if(g_bDisplayNcPinMark)dwMode|=DRAW_NC_MARK;
		DrawMainData(&dcMem,pDoc,dwMode,m_nPrintVExt,m_nPrintWExt,rcClip);
		dcMem.SelectObject(pOldBmp);



		//int nGetLine1 = ::GetDIBits(dcMem.m_hDC,(HBITMAP)bmp,0,sizeSheet.cy,NULL,pbih,DIB_RGB_COLORS);

		//rbg̎擾
		int nGetLine = ::GetDIBits(dcMem.m_hDC,(HBITMAP)bmp,0,sizeSheet.cy,bitbuff,pbih,DIB_RGB_COLORS);
		if(nGetLine==sizeSheet.cy){
			CFile file;
			if(!file.Open(pszFileName,CFile::modeCreate|CFile::modeWrite)) return FALSE;

			//////////////////////////////////
			//BITMAPFILEHEADEȐo
			BITMAPFILEHEADER bfh;
			bfh.bfType=0x4d42;
			bfh.bfSize= sizeof(BITMAPFILEHEADER)	//
					   +sizeof(BITMAPINFOHEADER)	//BITMAPINFOHEADER̃TCY
					   +sizeof(RGBQUAD)*2			//
					   +nDibSize;					//
			bfh.bfReserved1=bfh.bfReserved2=0;
			bfh.bfOffBits= sizeof(BITMAPFILEHEADER)	//
						  +sizeof(BITMAPINFOHEADER)	//BITMAPINFOHEADER̃TCY
						  +sizeof(RGBQUAD)*2;		//

			try{
				file.Write(&bfh,sizeof(BITMAPFILEHEADER));
			}
			catch(CFileException *e){
				e->Delete();
				return FALSE;
			}
		
			try{
				file.Write(pbih,headersize);
			}
			catch(CFileException *e){
				e->Delete();
				return FALSE;
			}


			try{
				file.Write(bitbuff,nDibSize);
			}
			catch(CFileException *e){
				e->Delete();
				delete[]bitbuff;
				return FALSE;
			}
		}
		delete[]pbihBuff;
		delete[]bitbuff;
		return TRUE;
	}
}

BOOL CBSchView::CopyEmf()
{
	CBSchDoc* pDoc = GetDocument();
	XBSchObjList* pTmpData;
	if(!pDoc) return FALSE;

	UINT nDrawAllBit=DRAW_TEMP_DATA;

	if((pTmpData=pDoc->GetTmpList())==NULL){		//ꎞf[^̃Xg𓾂
		return FALSE;
	}
	if(!pTmpData->size()){
		return FALSE;
	}

	CRect rc=pDoc->GetTmpRect();		//ꎞf[^̊O𓾂
	//rc.left-=2; rc.top-=2; rc.right+=2; rc.bottom+=2;
	rc.left-=100; rc.top-=100; rc.right+=100; rc.bottom+=100;

	//`pfoCXReLXg̍쐬
	CMetaFileDC mDC;
	CClientDC cDC(this);
	if(!mDC.CreateEnhanced(&cDC,NULL,NULL,NULL)) return FALSE;
	mDC.SetAttribDC(cDC.m_hDC);

	int nPrintVExt=2;
	int nPrintWExt=1;

	DWORD dwMode = DRAW_OFF;
	if(AfxGetApp()->GetProfileInt("Option","PrintColor",FALSE)){
		dwMode = DRAW_ON;
	}

	if(!AfxGetApp()->GetProfileInt("Option","PrintPartNum",TRUE)){
		dwMode |= DRAW_INH_PARTNUM;
	}
	if(!AfxGetApp()->GetProfileInt("Option","PrintPartName",TRUE)){
		dwMode |= DRAW_INH_PARTNAME;
	}

	if(m_COL.colBG!=RGB(255,255,255) ){
		if(AfxGetApp()->GetProfileInt("Option","PrintBgWhite",1)!=1){
			DrawPrintBg(&mDC,dwMode,nPrintVExt,nPrintWExt,&rc);
		}
	}
	

	dwMode |= DRAW_FOR_PRINT;
	DrawListData(&mDC,pTmpData,dwMode,nPrintVExt,nPrintWExt,rc,nDrawAllBit);	//ꎞf[^̃Xg̕`

	HENHMETAFILE    hmeta = mDC.CloseEnhanced();

	if(!OpenClipboard()) return FALSE;
    if(!EmptyClipboard()) return FALSE;
    SetClipboardData(CF_ENHMETAFILE, hmeta);
    CloseClipboard();

	return TRUE;
	
}


BOOL CBSchView::ExportEmf(LPCSTR pszFileName)
{
	CSize sizeSheet;
	CBSchDoc* pDoc = GetDocument();
	sizeSheet=pDoc->GetSheetSize();
	
	//`pfoCXReLXg̍쐬
	CMetaFileDC mDC;
	CClientDC cDC(this);
	if(!mDC.CreateEnhanced(&cDC,pszFileName,NULL,NULL)) return FALSE;

//	CRect rcBounds = CRect(0,0,30000,20000);
//	if(!mDC.CreateEnhanced(&cDC,pszFileName,&rcBounds,"BSch3V\0BSch3V\0")) return FALSE;
	mDC.SetAttribDC(cDC.m_hDC);
	int nPrintVExt=2;
	int nPrintWExt=1;

//	mDC.IntersectClipRect(-2,-2,sizeSheet.cx*2+2,sizeSheet.cy*2+2);
	CRect rc=CRect(0,0,sizeSheet.cx,sizeSheet.cy);

	DWORD dwMode = DRAW_OFF;
	if(AfxGetApp()->GetProfileInt("Option","PrintColor",FALSE)){
		dwMode = DRAW_ON;
	}

	if(g_bDisplayNcPinMark)dwMode|=DRAW_NC_MARK;

	//ۂ̕`

	//Version 0.63 ̔wiF
	if(m_bPrintColor && m_COL.colBG!=RGB(255,255,255) ){
		if(AfxGetApp()->GetProfileInt("Option","PrintBgWhite",1)!=1){
			DrawPrintBg(&mDC,dwMode,nPrintVExt,nPrintWExt,NULL);
		}
	}


	if(m_bPrintFrame) DrawSheetFrame(&mDC,dwMode,nPrintVExt,nPrintWExt,rc);
	//DWORD dwMode = DRAW_OFF;
	if(!AfxGetApp()->GetProfileInt("Option","PrintPartNum",TRUE)){
		dwMode |= DRAW_INH_PARTNUM;
	}
	if(!AfxGetApp()->GetProfileInt("Option","PrintPartName",TRUE)){
		dwMode |= DRAW_INH_PARTNAME;
	}
	dwMode |= DRAW_FOR_PRINT;
	DrawMainData(&mDC,pDoc,dwMode,nPrintVExt,nPrintWExt,rc);
	HENHMETAFILE hemf=mDC.CloseEnhanced();
	::DeleteEnhMetaFile(hemf);

	return TRUE;
}


///////////////////////////////////////////////////////
//IvV̐ݒ_CAON    1997/01/26 ǉ
//    1998/07/04 𑜓x̕Wl𓾂邽߂̉
//    bdl  ́Av^̐ݒƓ
void CBSchView::OnFilePrintOption() 
{
	((CBSchApp*)AfxGetApp())->UpdatePrinterSelection(FALSE);

	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	CPrintOpt dlg;
	
	//W𑜓xݒ
	CWinApp* pApp = AfxGetApp();
	CPrintDialog dlgPrn(FALSE);
	CDC dc;

	if(	pApp->GetPrinterDeviceDefaults(&(dlgPrn.m_pd))){
		HDC hdc=dlgPrn.CreatePrinterDC();
		CDC dc;
		dc.Attach(hdc);
		//dlg.m_nDefaultRes=GetDefaultPrintRes(&dc);
	}

	dlg.m_bPageFit=IniReadPrintPageFit();
	dlg.m_nPrintRes=IniReadPrintRes();
	//W𑜓xݒ ܂

	//    2005/09/11ǉ>>>>>>
	int left,upper,right,lower;
	IniReadPrintMargin(left,upper,right,lower);
	dlg.m_nLeftMargin	= left;
	dlg.m_nUpperMargin	= upper;
	dlg.m_nRightMargin	= right;
	dlg.m_nLowerMargin	= lower;
	//    <<<<<<2005/09/11ǉ


	dlg.m_bFrame  =pApp->GetProfileInt("Option","PrintSheetFrame",TRUE);
	dlg.m_bPartNum=pApp->GetProfileInt("Option","PrintPartNum",TRUE);
	dlg.m_bPartName=pApp->GetProfileInt("Option","PrintPartName",TRUE);//1998/07/22
	dlg.m_bPrintBmp=pApp->GetProfileInt("Option","PrintBitmap",FALSE);
	dlg.m_bPrintColor=pApp->GetProfileInt("Option","PrintColor",FALSE);
	if(dlg.DoModal()==IDOK){
		pApp->WriteProfileInt("Option","PrintSheetFrame",dlg.m_bFrame);
		pApp->WriteProfileInt("Option","PrintPartNum",dlg.m_bPartNum);
		pApp->WriteProfileInt("Option","PrintPartName",dlg.m_bPartName);//1998/07/22
		pApp->WriteProfileInt("Option","PrintBitmap",dlg.m_bPrintBmp);
		pApp->WriteProfileInt("Option","PrintColor",dlg.m_bPrintColor);
		IniWritePrintRes(dlg.m_nPrintRes);	//1998/07/04ǉ
		IniWritePrintPageFit(dlg.m_bPageFit);//ADD20051223


		//m_nPrintRes=dlg.m_nPrintRes;		//1998/07/04ǉ 2005/09/11RgAEg
		m_bBitmapPrint =dlg.m_bPrintBmp;

		//    2005/09/11ǉ>>>>>>
		left=	dlg.m_nLeftMargin;		
		upper=	dlg.m_nUpperMargin;
		right=	dlg.m_nRightMargin;
		lower=	dlg.m_nLowerMargin;
		IniWritePrintMargin(left,upper,right,lower);
		//    <<<<<<2005/09/11ǉ
	}
}
