/****************************************************************************
    NUT3W Numbering software for BSch3V
    Copyright (C) 2004-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

// DdLb.cpp : t@C
//

#include "stdafx.h"
#include "nu3w.h"
#include "DdLb.h"
#include ".\ddlb.h"


// CDdLb

IMPLEMENT_DYNAMIC(CDdLb, CListBox)
CDdLb::CDdLb()
{
}

CDdLb::~CDdLb()
{
}


BEGIN_MESSAGE_MAP(CDdLb, CListBox)
	ON_WM_DROPFILES()
END_MESSAGE_MAP()



// CDdLb bZ[W nh


void CDdLb::OnDropFiles(HDROP hDropInfo)
{
	// TODO : ɃbZ[W nh R[hǉ邩ȀĂяo܂B

//	CListBox::OnDropFiles(hDropInfo);
	int nFiles = DragQueryFile(hDropInfo,-1,NULL,0);
	if(nFiles>0){
		char szPath[_MAX_PATH];
		char szExt[_MAX_EXT];
		int n;
		for(n=0;n<nFiles;n++){
			::DragQueryFile(hDropInfo,n,szPath,_MAX_PATH);
			_splitpath(szPath,NULL,NULL,NULL,szExt);
			if(_stricmp(szExt,".ce3")==0){
				AddString(szPath);	//Xg{bNXւ̃Zbg
			}
		}
		::DragFinish(hDropInfo);
		SetListboxWidth();
		GetParent()->SendMessage(WM_COMMAND,MAKELONG(GetDlgCtrlID(),LBN_SELCHANGE),(long)m_hWnd);
	}
}


void CDdLb::SetListboxWidth()
{
	CString str;
	CDC* pDC;
	CFont* pOldFont;
	CFont* pFont = GetFont();
	CSize textsize;
	int maxwidth=0;
	int i,n;
	pDC = GetDC();

	pOldFont=pDC->SelectObject(pFont);
	n = GetCount();
	for(i=0;i<n;i++){
		GetText(i,str);
		textsize = pDC->GetTextExtent(str);
		if(textsize.cx>maxwidth) maxwidth = textsize.cx;
	}
	SetHorizontalExtent(maxwidth+20);
	pDC->SelectObject(pOldFont);
	ReleaseDC(pDC);
}