/****************************************************************************
    BSch3V and Utility common file.
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSch}ʗvfiNX
****************************************************************************/
#ifndef XBSCHCOMPONENT_H
#define XBSCHCOMPONENT_H

#include "xbsch.h"
#include "xbschobj.h"
#include "complib.h"



//    (0) 0      (1) 90     (2) 180    (3) 270
//                                
//    s     k     a     q     
//  kq as qk sa
//    a     q     s     k     
//                                
//
//    (4) M0     (5) M90    (6) M180   (7) M270
//                                
//    s     k     a     q     
//  qk sa kq as
//    a     q     s     k     
//                                


class SXBSchComponent:public SXBSchObj
{
public:
	enum BSCHCOMP_DIR{
		COMPONENT_DIR_0		=0,
		COMPONENT_DIR_90	=1,
		COMPONENT_DIR_180	=2,
		COMPONENT_DIR_270	=3,
		COMPONENT_DIR_M0	=4,
		COMPONENT_DIR_M90	=5,
		COMPONENT_DIR_M180	=6,
		COMPONENT_DIR_M270	=7
	};

	enum BSCHCOMP_TEXTPOS{
		COMPONENT_DEFAULT_REFNUM_X	=2,
		COMPONENT_DEFAULT_REFNUM_Y	=10,
		COMPONENT_DEFAULT_NAME_X	=2,
		COMPONENT_DEFAULT_NAME_Y	=20
	};

	enum BSCHCOMP_PINLTRB{
		COMPONENT_HASLPIN	=1,
		COMPONENT_HASTPIN	=2,
		COMPONENT_HASRPIN	=4,
		COMPONENT_HASBPIN	=8,
	};

	//RXgN^
	SXBSchComponent();
	//fXgN^
	virtual ~SXBSchComponent();
	SXBSchComponent(const SXBSchComponent&);				//Rs[RXgN^
	SXBSchComponent& operator=(const SXBSchComponent&);	//Zq
	bool readEmbLibCe3(SReadCE3&, SCompInfo*,string& );
	bool writeEmbLibCe3(SWriteCE3& wce3);

	bool readCe3(SReadCE3&,const SPoint* ,SXBSchDoc*);
	bool writeCe3(SWriteCE3& ,const SPoint* );

    //ID̎擾
	unsigned id(){return ID_COMPONENT;}
protected:
	string	m_name;			//O
	SPoint	m_name_pos;		//Ǒ_̃ItZbg
	bool	m_name_hide;	//O\
	bool	m_name_drawSizeIsValid;
	SSize	m_name_drawSize;
	bool	m_name_horiz;
	string	m_refnum;		//QƔԍ
	SPoint	m_refnum_pos;	//QƔԍ̌_̃ItZbg
	bool	m_refnum_hide;	//ԍ\
	bool	m_refnum_drawSizeIsValid;
	SSize	m_refnum_drawSize;
	bool	m_refnum_horiz;
	int		m_block;		//ubNԍ
	int		m_dir;			//
	int		m_pinltrb;		//LTRBɃs݂Ă邩ǂ̃tO
	SCompIndex* m_compInfoIndex;		//ȉւ̃|C^
//	SCompIndex* m_embeddedCompInfoIndex;	//ߍ񂾕ȉւ̃|C^
	bool	m_useEmbeddedLib;
	string	m_orgname;		//璷ǁACuǂݑ˂ic߂ɕKv
	string	m_note;

	string	m_packagename;	//Version 0.63 pbP[W
	string	m_mfrpnum;		//Version 0.63 Ҍ^
	string	m_mfr;			//Version 0.63 

protected:
	void	mirrorDir();		//m_dirϐE]
	void	rotateDir();		//m_dirϐE]
	void	resetRefnumPos();	//QƔԍ̈ʒuftHg̈ʒuɕύX
	void	resetNamePos();		//ïʒuftHg̈ʒuɕύX
//	void	setPinLtrb();		//LTRBɃs݂Ă邩ǂ̃tO̐ݒ



public:
	void	setPinLtrb();		//LTRBɃs݂Ă邩ǂ̃tO̐ݒ
	
	SXBSchObj* duplicate();	//s
	//W̐ݒ  m_p2ւ̐ݒ𖳌ɂĂ
	void setX2(int){}
	void setY2(int){}
	void setP2(const SPoint&){}

	void move(int offsetx,int offsety);	//ʒu𓮂
	void mirrorH(int x); //XWw肵čE]s
	virtual void mirrorH(); //E]s
	void rotate(const SPoint& p); //XYSWw肵āA]s
	void rotate();	//]s
	int qSelectWeight(const SPoint& p);				//_w肵đIdvxԂ
	unsigned testSelection(const SRect& rc);		//͈͂w肵đIs
	unsigned testSelectionForDrag(const SRect& rc); //͈͂IăhbOIs
	bool qRedraw(const SRect&){return true;}		//`悪KvǂԂ qRedraw()͏ɕ`B
	
	SRect area();	//L͈͂Ԃ
	SRect bodyArea();	//L͈͂Ԃ

	SRect rotateRect();
	SSize size() const;
	SRect nameArea() const;
	SRect refnumArea() const;

	void setNameDrawSize(const SSize& size);	//`TCY̐ݒ
	void setRefnumDrawSize(const SSize& size);	//`TCY̐ݒ

public:
	void setName(const char* psz);
	const char* name() const {return m_name.c_str();}
	void setNameHorizontal(bool bHoriz);	//2005/04/09
	bool nameHorizontal() const {return m_name_horiz;}//2005/04/09

	void setNote(const char* psz);
	const char* note() const {return m_note.c_str();}
	void setNamePos(const SPoint& p){m_name_pos = p;}
	void moveNamePos(int offsetx,int offsety);
	SPoint namePos(){return m_name_pos;}

	void setRefnum(const char* psz);
	const char* refnum() const {return m_refnum.c_str();}
	void setRefnumHorizontal(bool bHoriz);//2005/04/09
	bool refnumHorizontal() const {return m_refnum_horiz;}//2005/04/09
	void setRefnumPos(const SPoint& p){m_refnum_pos = p;}
	void moveRefnumPos(int offsetx,int offsety);
	SPoint refnumPos(){return m_refnum_pos;}

	void setOrgName(const char* psz);
	const char* orgname() const {return m_orgname.c_str();}
	const SCompIndex* compInfoIndex() const {return m_compInfoIndex;}
	void setCompInfoIndex(const SCompIndex* pIndex);

	//>>>> Version 0.63
	void setPackageName(const char* psz);
	const char* packagename() const {return m_packagename.c_str();}

	void setMfr(const char* psz);
	const char* mfr() const {return m_mfr.c_str();}

	void setMFrPNum(const char* psz);
	const char* mfrpnum() const {return m_mfrpnum.c_str();}
	//<<<< Version 0.63


	
	const SPin*  pinEnd(int nIndex,int& nLtrb,SPoint& ptEnd) const; //s̈ʒu擾
	SPoint pinPosition(int)	const;//nԖڂ̃s̈ʒu𓾂B
	int pinCount() const; //s̐𓾂


	void setBlock(int n);
	int block(){return m_block;}

	void setDir(int n);
	int dir(){return m_dir;}
	
	bool canAttribute(){return true;}	//Agr[g̕ύX\ȏꍇtrueԂB
};

#endif
