/****************************************************************************
    BSch3V and Utility common file.
    Copyright (C) 2002-2005 H.Okada

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*****************************************************************************/

/****************************************************************************
** XBSch}ʗvfGg[NX̎
****************************************************************************/
#include <stdio.h>
#include <assert.h>
#include <string>
using namespace std;
#include "ce3io.h"
#include "xbschentry.h"
#include "xbschline.h"
#include "xbschentry.h"

//RIGHT_DOWN
//m_p2
//
//
//
//
//
//
//
//
//
//
// m_p1

//LEFT_DOWN
// m_p2
//
//
//
//
//
//
//
//
//
//
//m_p1


//RXgN^
SXBSchEntry::SXBSchEntry()
{
	//ftHgōɂȂ
	m_p1=SPoint(0,10);
	m_p2=SPoint(10,0);
}

//m_p1  m_p2̉ɂȂ悤ɐݒ肷B
void SXBSchEntry::normalize()
{
	if(m_p1.y() < m_p2.y()){
		SPoint point = m_p1;
		m_p1 = m_p2;
		m_p2 = point;
	}
}


//Gg[̉EA擾
unsigned SXBSchEntry::aspect()
{
	normalize();
	if(m_p1.x() < m_p2.x()) return LEFT_DOWN;
	else	return RIGHT_DOWN;
}


//Gg[̉EAݒ肷
void SXBSchEntry::setAspect(int aspect)
{
	m_p2.setY( m_p1.y() - 10);
	if(aspect == RIGHT_DOWN){
		m_p2.setX( m_p1.x() - 10);
	}else{
		m_p2.setX( m_p1.x() + 10);
	}
}
		
/*
//Xg[̓ǂݍ ~ -ENTRY
bool SXBSchEntry::readStream(SCsvIStream* pStrm,const SPoint* pptOrigin)
{
	if(!readStreamEx(pStrm,pptOrigin,"ENTRY")) return false;
	//Entrym_p2Đݒ肷B
	setAspect(aspect());
	return true;
}
*/


bool SXBSchEntry::readCe3(SReadCE3& rce3,const SPoint* pptOrigin,SXBSchDoc*)
{
	if(!readCe3Ex(rce3,pptOrigin,"ENTRY")) return false;
	setAspect(aspect());
	return true;
}

bool SXBSchEntry::writeCe3(SWriteCE3& wce3,const SPoint* pptOrigin)
{
	normalize();
	return writeCe3Ex(wce3,pptOrigin,"ENTRY");
}


/*
//Xg[ւ̏݁@+ENTRY ~ -ENTRY
bool SXBSchEntry::writeStream(SCsvOStream* pStrm,const SPoint* pptOrigin)
{
	normalize();
	return writeStreamEx(pStrm,pptOrigin,"ENTRY");
}
*/

//s
SXBSchObj* SXBSchEntry::duplicate()
{
	SXBSchObj* newObj =new SXBSchEntry(*this);
	return newObj;
}

//_w肵đIdvxԂ
//int SXBSchEntry::qSelectWeight(const SPoint& p)
//{
//	int nResult = PointAndRectMag(p,area());
//	if(nResult) return (nResult | ON_OBJ);
//	else		return 0;
//}

//͈͂w肵đIs
//unsigned SXBSchEntry::testSelection(const SRect& rc)
//{
//	if( rc.intersects(area()) ){
//		return SELECT_ALL;
//	}else{
//		return 0;
//	}
//}

//W̐ݒ  
//m_p1ւ̐ݒsm_p2ւ̐ݒB
void SXBSchEntry::setX1(int x)
{
	if(aspect()==RIGHT_DOWN){
		m_p2.setX(x-10);
	}else{
		m_p2.setX(x+10);
	}
	m_p1.setX(x);
}

void SXBSchEntry::setY1(int y)
{
	m_p1.setY(y);
	m_p2.setY(y-10);
}

void SXBSchEntry::setP1(const SPoint& p1)
{
	setX1(p1.x());
	setY1(p1.y());
}


bool SXBSchBusEntry::readCe3(SReadCE3& rce3,const SPoint* pptOrigin,SXBSchDoc*)
{
	if(!readCe3Ex(rce3,pptOrigin,"BENTRY")) return false;
	setAspect(aspect());
	return true;
}

bool SXBSchBusEntry::writeCe3(SWriteCE3& wce3,const SPoint* pptOrigin)
{
	normalize();
	return writeCe3Ex(wce3,pptOrigin,"BENTRY");
}


//s
SXBSchObj* SXBSchBusEntry::duplicate()
{
	SXBSchObj* newObj =new SXBSchBusEntry(*this);
	return newObj;
}
