// ---------------------------------------------------------------------------
//  Hyper Operating System V4  ե졼                           
//    HOS_MAX_TPRI API ν                                                 
//                                                                            
//                                    Copyright (C) 1998-2003 by Project HOS  
//                                    http://sourceforge.jp/projects/hos/     
// ---------------------------------------------------------------------------


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "defercd.h"
#include "maxtpri.h"
#include "analyze.h"



// 󥹥ȥ饯
CApiMaxTpri::CApiMaxTpri()
{
	// ѥ᡼ʸ
	m_iParamSyntax[0] = 0;		// ñȥѥ᡼
	m_iParams         = 1;

	m_iMaxPri = 0;
}


// ǥȥ饯
CApiMaxTpri::~CApiMaxTpri()
{
}



// APIβ
int CApiMaxTpri::AnalyzeApi(const char* pszApiName, const char* pszParams)
{
	// API̾å
	if ( strcmp(pszApiName, "HOS_MAX_TPRI") != 0 )
	{
		return CFG_ERR_NOPROC;
	}

	// ¿å
	if ( m_iMaxPri > 0 )
	{
		return CFG_ERR_MULTIDEF;
	}

	if ( atoi(pszParams) <= 0 )
	{
		return CFG_ERR_PARAM;
	}
	m_iMaxPri = atoi(pszParams);

	return CFG_ERR_OK;
}


// ʸŸ
int CApiMaxTpri::AutoId(void)
{
	return CFG_ERR_OK;
}


// cfgե񤭽Ф
void  CApiMaxTpri::WriteCfgDef(FILE* fp)
{
	if ( m_iMaxPri == 0 )
	{
		m_iMaxPri = DEFAULT_MAXTPRI;

	}

	fprintf(
		fp,
		"\n\n\n"
		"/* ------------------------------------------ */\n"
		"/*           create ready queue               */\n"
		"/* ------------------------------------------ */\n"
		"\n"
		"T_MKNL_QUE mknl_rdq_tbl[%d];\n"
		"const INT  mknl_rdq_cnt = %d;\n",
		m_iMaxPri,
		m_iMaxPri);
}


// ---------------------------------------------------------------------------
//  Copyright (C) 1998-2003 by Project HOS                                    
// ---------------------------------------------------------------------------
