/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå ǡ塼                               */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_dtq_h__
#define __HOS_V4__knl_dtq_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_DTQID	TMIN_DTQID			/* ǡ塼IDκǾ */
#define KERNEL_TMAX_DTQID	(KERNEL_TMIN_DTQID + kernel_dtqcb_cnt - 1)
												/* ǡ塼IDκ */



/* ------------------------------------------ */
/*                 ޥ                 */
/* ------------------------------------------ */

/* ΰΥ */
#define TSZ_DTQ(dtqcnt)		((SIZE)((UINT)(dtqcnt) * sizeof(VP_INT)))



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* ǡ塼 */
typedef struct t_cdtq
{
	ATR    dtqatr;		/* ǡ塼° */
	UINT   dtqcnt;		/* ǡ塼ΰ(ǡθĿ) */
	VP     dtq;			/* ǡ塼ΰƬ */
} T_CDTQ;

/* ǡ塼 */
typedef struct t_rdtq
{
	ID   stskid;		/* ǡ塼ԤƬΥIDֹ */
	ID   rtskid;		/* ǡ塼μԤƬΥIDֹ */
	UINT sdtqcnt;		/* ǡ塼äƤǡο */
} T_RDTQ;


/* ǡ塼ȥ֥å(ROM) */
typedef struct t_kernel_dtqcb_rom
{
	ATR    dtqatr;		/* ǡ塼° */
	UINT   dtqcnt;		/* ǡ塼ΰ(ǡθĿ) */
	VP_INT *dtq;		/* ǡ塼ΰƬ */
} T_KERNEL_DTQCB_ROM;

/* ǡ塼ȥ֥å(RAM) */
typedef struct t_kernel_dtqcb_ram
{
	T_MKNL_QUE sndque;	/* ǡ塼Ԥ塼 */
	T_MKNL_QUE rcvque;	/* ǡ塼Ԥ塼 */
	UINT       head;	/* ǡƬ */
	UINT       datacnt;	/* ǡθĿ */
	const T_KERNEL_DTQCB_ROM *dtqcb_rom;	/* ǡ塼ȥ֥åROMؤΥݥ */
} T_KERNEL_DTQCB_RAM;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* ǡ塼 */
extern       T_KERNEL_DTQCB_RAM *kernel_dtqcb_ram_tbl[];	/* ǡ塼ȥ֥åơ֥(RAM) */
extern const INT kernel_dtqcb_cnt;							/* ǡ塼ȥ֥åĿ */

/* ǡ塼ȥ֥åѴޥ */
#define KERNEL_DTQID_TO_DTQCB_RAM(dtqid)	(kernel_dtqcb_ram_tbl[(dtqid) - KERNEL_TMIN_DTQID])
															/* ǡ塼IDDTQCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */
#ifdef __cplusplus
extern "C" {
#endif

/* ǡ塼 */
#define kernel_ini_dtq()									/* ǡ塼ν */
ER      cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);			/* ǡ塼 */
ER_ID   acre_dtq(const T_CDTQ *pk_cdtq);					/* ǡ塼(IDֹ漫ưդ) */
ER      kernel_cre_dtq(ID dtqid, const T_CDTQ *pk_cdtq);	/* ǡ塼(ͥؿ) */
ER      del_dtq(ID dtqid);									/* ǡ塼κ */
ER      snd_dtq(ID dtqid, VP_INT data);						/* ǡ塼ؤ */
ER      psnd_dtq(ID dtqid, VP_INT data);					/* ǡ塼ؤ(ݡ) */
#define ipsnd_dtq	psnd_dtq								/* ǡ塼ؤ(ݡ 󥿥ƥѥޥ) */
ER      tsnd_dtq(ID dtqid, VP_INT data, TMO tmout);			/* ǡ塼ؤ(ॢȤ) */
ER      fsnd_dtq(ID dtqid, VP_INT data);					/* ǡ塼ؤζ */
#define ifsnd_dtq	fsnd_dtq								/* ǡ塼ؤζ(󥿥ƥѥޥ) */
ER      rcv_dtq(ID dtqid, VP_INT *p_data);					/* ǡ塼μ */
ER      prcv_dtq(ID dtqid, VP_INT *p_data);					/* ǡ塼μ(ݡ) */
ER      trcv_dtq(ID dtqid, VP_INT *p_data, TMO tmout);		/* ǡ塼μ(ॢȤ) */
ER      ref_dtq(ID dtqid, T_RDTQ *pk_rdtq);					/* ǡ塼ξֻ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_dtq_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
