/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå ٥ȥե饰                             */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_flg_h__
#define __HOS_V4__knl_flg_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_FLGID	TMIN_FLGID			/* ٥ȥե饰IDκǾ */
#define KERNEL_TMAX_FLGID	(KERNEL_TMIN_FLGID + kernel_flgcb_cnt - 1)
												/* ٥ȥե饰IDκ */

/* ӥåȥѥΥӥåȿ */
#define TBIT_FLGPTN			16					/* ٥ȥե饰Υӥåȿ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* ٥ȥե饰 */
typedef struct t_cflg
{
	ATR    flgatr;		/* ٥ȥե饰° */
	FLGPTN iflgptn;		/* ٥ȥե饰Υӥåȥѥν */
} T_CFLG;

/* ٥ȥե饰 */
typedef struct t_rflg
{
	ID     wtskid;		/* ٥ȥե饰ԤƬΥIDֹ */
	FLGPTN flgptn;		/* ٥ȥե饰θߤΥӥåȥѥ */
} T_RFLG;


/* ٥ȥե饰ȥ֥å(ROM) */
typedef struct t_kernel_flgcb_rom
{
	ATR    flgatr;		/* ٥ȥե饰° */
	FLGPTN iflgptn;		/* ٥ȥե饰Υӥåȥѥν */
} T_KERNEL_FLGCB_ROM;

/* ٥ȥե饰ȥ֥å(RAM) */
typedef struct t_kernel_flgcb_ram
{
	T_MKNL_QUE que;			/* ٥ȥե饰Ԥ */
	FLGPTN     flgptn;		/* ٥ȥե饰Υӥåȥѥ */
	const T_KERNEL_FLGCB_ROM* flgcb_rom;	/* ٥ȥե饰ȥ֥åROMؤΥݥ */
} T_KERNEL_FLGCB_RAM;


/* Ԥե饰¤ */
typedef struct t_kernel_flginf
{
	MODE   wfmode;		/* Ԥ⡼ */
	FLGPTN waiptn;		/* Ԥӥåȥѥʲѥȷ) */
} T_KERNEL_FLGINF;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* ٥ȥե饰 */
extern       T_KERNEL_FLGCB_RAM *kernel_flgcb_ram_tbl[];	/* ٥ȥե饰ȥ֥åơ֥(RAM) */
extern const INT kernel_flgcb_cnt;							/* ٥ȥե饰ȥ֥åĿ */

#define KERNEL_FLGID_TO_FLGCB_RAM(flgid)	(kernel_flgcb_ram_tbl[(flgid) - KERNEL_TMIN_FLGID])
															/* ٥ȥե饰IDFLGCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ٥ȥե饰 */
void    kernel_ini_flg(void);								/* ٥ȥե饰ν */
ER      cre_flg(ID flgid, const T_CFLG *pk_cflg);			/* ٥ȥե饰 */
ER_ID   acre_flg(const T_CFLG *pk_cflg);					/* ٥ȥե饰(IDֹ漫ưդ) */
ER      kernel_cre_flg(ID flgid, const T_CFLG *pk_cflg);	/* ٥ȥե饰(ͥؿ) */
ER      del_flg(ID flgid);									/* ٥ȥե饰κ */
ER      set_flg(ID flgid, FLGPTN setptn);					/* ٥ȥե饰Υå */
#define iset_flg	set_flg									/* ٥ȥե饰Υå(󥿥ƥѥޥ) */
ER      clr_flg(ID flgid, FLGPTN clrptn);					/* ٥ȥե饰Υꥢ */
ER      wai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/* ٥ȥե饰Ԥ */
ER      pol_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn);
															/* ٥ȥե饰Ԥ(ݡ) */
ER      twai_flg(ID flgid, FLGPTN waiptn, MODE wfmode, FLGPTN *p_flgptn, TMO tmout);
															/* ٥ȥե饰Ԥ(ॢȤ) */
ER      ref_flg(ID flgid, T_RFLG *pk_rflg);					/* ٥ȥե饰ξֻ */
BOOL    kernel_chk_flg(T_KERNEL_FLGCB_RAM *flgcb_ram, T_KERNEL_FLGINF *pk_flginf);
															/* ե饰Ƥ뤫å */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_flg_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
