/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ͥ¸إå ޥե                                   */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#ifndef __HOS_V4__knl_sem_h__
#define __HOS_V4__knl_sem_h__


#include "knl_hos.h"



/* ------------------------------------------ */
/*                                    */
/* ------------------------------------------ */

/* IDϰ */
#define KERNEL_TMIN_SEMID	TMIN_SEMID			/* ޥեIDκǾ */
#define KERNEL_TMAX_SEMID	(KERNEL_TMIN_SEMID + kernel_semcb_cnt - 1)
												/* ޥեIDκ */



/* ------------------------------------------ */
/*                                      */
/* ------------------------------------------ */

/* ޥե */
typedef struct t_csem
{
	ATR  sematr;		/* ޥե° */
	UINT isemcnt;		/* ޥե񸻿ν */
	UINT maxsem;		/* ޥեκ񸻿 */
} T_CSEM;

/* ޥե־ */
typedef struct t_rsem
{
	ID   wtskid;		/* ޥեԤƬΥIDֹ */
	UINT semcnt;		/* ޥեθߤλ񸻿 */
} T_RSEM;


/* ޥեȥ֥å(ROM) */
typedef struct t_kernel_semcb_rom
{
	ATR  sematr;		/* ޥե° */
	UINT isemcnt;		/* ޥե񸻿ν */
	UINT maxsem;		/* ޥեκ񸻿 */
} T_KERNEL_SEMCB_ROM;

/* ޥեȥ֥å(RAM) */
typedef struct t_kernel_semcb_ram
{
	T_MKNL_QUE que;		/* ޥեԤ塼 */
	UINT       semcnt;	/* ޥեλ񸻿 */
	const T_KERNEL_SEMCB_ROM *semcb_rom;	/* ޥեȥ֥åROMؤΥݥ */
} T_KERNEL_SEMCB_RAM;



/* ---------------------------------- */
/*        Хѿ          */
/* ---------------------------------- */

/* ޥե */
extern       T_KERNEL_SEMCB_RAM *kernel_semcb_ram_tbl[];	/* ޥեȥ֥åơ֥(RAM) */
extern const INT kernel_semcb_cnt;							/* ޥեȥ֥åĿ */

/* ޥեȥ֥åѴޥ */
#define KERNEL_SEMID_TO_SEMCB_RAM(semid)	(kernel_semcb_ram_tbl[(semid) - KERNEL_TMIN_SEMID])
															/* ޥեIDSEMCB RAMɥ쥹 */



/* ------------------------------------------ */
/*                ؿ                    */
/* ------------------------------------------ */

#ifdef __cplusplus
extern "C" {
#endif

/* ޥե */
void    kernel_ini_sem(void);								/* ޥեν */
ER      cre_sem(ID semid, const T_CSEM *pk_csem);			/* ޥե */
ER_ID   acre_sem(const T_CSEM *pk_csem);					/* ޥե(IDֹ漫ưդ) */
ER      kernel_cre_sem(ID semid, const T_CSEM *pk_csem);	/* ޥե(ͥؿ) */
ER      del_sem(ID semid);									/* ޥեκ */
ER      sig_sem(ID semid);									/* ޥե񸻤ֵ */
#define isig_sem sig_sem									/* ޥե񸻤ֵ(󥿥ƥѥޥ) */
ER      wai_sem(ID semid);									/* ޥե񸻤γ */
ER      pol_sem(ID semid);									/* ޥե񸻤γ(ݡ) */
ER      twai_sem(ID semid, TMO tmout);						/* ޥե񸻤γ(ॢȤ) */
ER      ref_sem(ID semid, T_RSEM *pk_rsem);					/* ޥեξֻ */

#ifdef __cplusplus
}
#endif



#endif	/* __HOS_V4__knl_sem_h__ */


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
