/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ٥ȥե饰                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_flg.h"
#include "knl_mem.h"



/* ٥ȥե饰κ */
ER del_flg(
		ID flgid)	/* оݤΥ٥ȥե饰IDֹ */
{
	T_KERNEL_FLGCB_RAM *flgcb_ram;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( flgid < KERNEL_TMIN_FLGID || flgid > KERNEL_TMAX_FLGID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();		/* ƥΥå */

	flgcb_ram = KERNEL_FLGID_TO_FLGCB_RAM(flgid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( flgcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif
	
	/* Ԥβ */
	mknl_clr_que(&flgcb_ram->que);
	
	/* β */
	kernel_fre_mem(flgcb_ram);
	KERNEL_FLGID_TO_FLGCB_RAM(flgid) = NULL;
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
