/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ Ĺס                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Ĺ֥åֵ */
ER rel_mpf(
		ID mpfid,		/* ֥åоݤθĹסIDֹ */
		VP blk)			/* ֵѤ֥åƬ */
{
	T_KERNEL_MPFCB_RAM *mpfcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* ID */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_NOEXS;	/* ֥̤ */
	}
#endif

	mtcb = mknl_ref_qhd(&mpfcb_ram->que);	/* ԤƬ饿Ф */
	if ( mtcb != NULL )
	{
		/* ԤԤ */
		mknl_rmv_que(mtcb);						/* סԤ󤫤 */
		mknl_rmv_tmout(mtcb);					/* ॢԤ󤫤 */
		mtcb->data = (VP_INT)blk;				/* ֥åƬϤ */
		mknl_wup_tsk(mtcb, E_OK);				/* Ԥ */
		
		mknl_exe_dsp();		/* ǥѥåμ¹ */
		mknl_exe_tex();		/* 㳰μ¹ */
	}
	else
	{
		/* Ԥ̵Хסֵ */
		*(VP *)blk      = mpfcb_ram->free;
		mpfcb_ram->free = blk;
	}

	mknl_unl_sys();		/* ƥΥå */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
