/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ޥե                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"



/* ޥե񸻤γ(ݡ) */
ER pol_sem(
		ID semid)	/* 񸻳оݤΥޥեIDֹ */
{
	T_KERNEL_SEMCB_RAM *semcb_ram;
	ER ercd;

	/* ID Υå */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;
	}
#endif
	
	mknl_loc_sys();		/* ƥΥå */

	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);

	/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();		/* ƥΥå */
		return E_NOEXS;
	}
#endif

	/* ޥե񸻤Ǥ̵Хॢ */
	if ( semcb_ram->semcnt == 0 )
	{
		ercd = E_TMOUT;		/* ॢ */
	}
	else
	{
		semcb_ram->semcnt--;	/* ޥե񸻤γ */
		ercd = E_OK;
	}

	mknl_unl_sys();		/* ƥΥå */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
