/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ƥִ                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tim.h"



/* ޥꥹȴ */
T_KERNEL_TIM *kernel_tml_head;		/* ޥꥹƬ */
T_KERNEL_TIM *kernel_tml_ptr;		/* ޥꥹȥݥ */



/* ƥåζ */
ER isig_tim(void)
{
	T_KERNEL_TIM* tim_ptr;
	UW            prev_tim;
	RELTIM        tic;

	/* û륿ƥå򻻽 */
	/* 㤨 10/3 ms ʤ 3, 3, 4, 3, 3, 4, ... ȥȤƤ */
	kernel_tic_cnt--;
	if ( kernel_tic_cnt < kernel_tic_mod )
	{
		tic = kernel_tic_div + 1;	/* ڤʤʬ */
	}
	else
	{
		tic = kernel_tic_div;
	}
	if ( kernel_tic_cnt == 0 )
	{
		kernel_tic_cnt = kernel_tic_deno;
	}

	mknl_loc_sys();		/* ƥΥå */

	/* ƥॿ˲û */
	prev_tim = kernel_systim.ltime;
	kernel_systim.ltime += tic;
	if ( kernel_systim.ltime < prev_tim )	/* 夬꤬ʤ */
	{
		kernel_systim.utime++;
	}
	
	/* ޥ֥ȤΥϥɥƤӽФ */
	if ( kernel_tml_head != NULL )
	{
		/* ݥ */
		kernel_tml_ptr = kernel_tml_head;
		
		do /* ꥹޤǷ֤ */
		{
			/* Υݥ󥿤 */
			tim_ptr        = kernel_tml_ptr;
			kernel_tml_ptr = tim_ptr->next;
			
			/* ޥϥɥƤӽФ */
			tim_ptr->timhdr(tim_ptr, tic);
			
			/* ϥɥǺ줿 */
			if ( kernel_tml_ptr == NULL )
			{
				break;
			}
		} while ( kernel_tml_ptr != kernel_tml_head );
		
		/* ݥ󥿤Υꥢ */
		kernel_tml_ptr = NULL;
	}
	
	/* ॢԤΥ */
	mknl_tic_tmout(tic);	/* ॢȥ塼˥ƥå򶡵 */
	
	mknl_unl_sys();			/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
