/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ ǽ                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* εư */
ER act_tsk(
		ID tskid)	/* ID */
{
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM       *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ȥ֥å */
	if ( tskid == TSK_SELF )
	{
		/* Ѵ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* 󥿥ƥȤ TSK_SELF */
			mknl_unl_sys();		/* ƥΥå */
			return E_ID;		/* IDֹ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDֹѴ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* ƥΥå */
			return E_NOEXS;		/* ֥̤ */
		}
#endif
	}

	/* ֥ȾȽ */
	if ( mknl_get_tskstat(&tcb_ram->mtcb) != TTS_DMT )
	{
		/* ˼¹Ծ֤ʤ鵯ư׵򥭥塼 */
#ifdef HOS_ERCHK_E_QOVR
		if ( tcb_ram->actcnt >= TMAX_ACTCNT )
		{
			mknl_unl_sys();	/* ƥΥå */
			return E_QOVR;	/* 塼󥰥Сե */
		}
#endif

		/* ư׵򥭥塼 */
		tcb_ram->actcnt++;
	}
	else
	{
		/* ٻ߾֤ʤ饿ư */
		tcb_rom = tcb_ram->tcb_rom;
	
		/* ¹ԥƥϿ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* Ͽ륿 */
				tcb_rom->exinf,			/* γĥ */
				(FP)kernel_task_entry,	/* εư */
				tcb_rom->itskpri,		/* εưͥ */
				tcb_rom->stksz,			/* Υåΰ襵 */
				tcb_rom->stk			/* ΥåΰƬ */
			);	
		tcb_ram->suscnt = 0;	/* Ԥͥȥꥢ */
		tcb_ram->wupcnt = 0;	/* Ԥ׵ᥭ塼󥰥ꥢ */
		
		mknl_exe_dsp();			/* ǥѥåμ¹ */
		mknl_exe_tex();			/* 㳰μ¹ */
	}

	mknl_unl_sys();	/* ƥΥå */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
