/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ITRONͥ °Ʊǽ                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ε */
ER wup_tsk(ID tskid)
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ϰϥå */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* IDֹ */
	}
#endif

	mknl_loc_sys();	/* ƥΥå */

	/* ȥ֥å */
	if ( tskid == TSK_SELF )
	{
		/* Ѵ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* 󥿥ƥȤ TSK_SELF */
			mknl_unl_sys();		/* ƥΥå */
			return E_ID;		/* IDֹ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDֹѴ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* ֥¸ߥå */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* ƥΥå */
			return E_NOEXS;		/* ֥̤ */
		}
#endif
	}

	/* ֥Ȥξ֥å */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )
	{
		mknl_unl_sys();	/* ƥΥå */
		return E_OBJ;	/* ֥Ⱦ֥顼 */
	}
#endif

	/* ׵ᥭ塼󥰤Υå */
	if ( !(mknl_get_tskstat(&tcb_ram->mtcb) & TTS_WAI)
			|| mknl_get_tskwait(&tcb_ram->mtcb) != TTW_SLP )
	{
#ifdef HOS_ERCHK_E_QOVR
		if ( tcb_ram->wupcnt >= TMAX_WUPCNT )
		{
			mknl_unl_sys();	/* ƥΥå */
			return E_QOVR;
		}
#endif
		tcb_ram->wupcnt++;
		mknl_unl_sys();	/* ƥΥå */
		return E_OK;	/* ׵򥭥塼󥰤ƽλ */
	}
	
	/* 򵯾 */
	mknl_rmv_tmout(&tcb_ram->mtcb);			/* ॢԤ󤫤 */
	mknl_wup_tsk(&tcb_ram->mtcb, E_OK);		/* Ԥֲ */
	
	mknl_exe_dsp();		/* ǥѥåμ¹ */
	mknl_exe_tex();		/* 㳰μ¹ */
	
	mknl_unl_sys();		/* ƥΥå */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
