/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0 Real-Time OS                  */
/*    ̥ͥ ॢȥ塼                                     */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"



/* Хѿ */
T_MKNL_TCB *mknl_timout_head;		/* ॢȥ塼Ƭ */



/* ॢȤ˥ƥå */
void mknl_tic_tmout(
		RELTIM tictim)		/* ɲä륿ƥå */
{
	register T_MKNL_TCB *mtcb;

	/* ˥ԡ */
	mtcb = mknl_timout_head;

	/* ॢȥ塼ʤ꥿ */
	if ( mtcb == NULL )
	{
		return;
	}

	/* ॢȥ塼ν */
	for ( ; ; )
	{
		/* ॢȤãʤʤ */
		if ( tictim < mtcb->diftim )
		{
			mtcb->diftim -= tictim;		/* ॢȻ֤򸺻 */
			break;
		}
		
		tictim -= mtcb->diftim;			/* ƥå򸺻 */
		
		mknl_wup_tsk(mtcb, E_TMOUT);	/* ॢȵ */
		mknl_exe_dsp();					/* ٱǥѥåͽԤ */
		
		/* 塼鳰 */
		if ( mtcb->tm_next == mtcb )	/* ǸΣĤʤ */
		{
			/* 塼ˤ */
			mtcb->tm_prev = NULL;
			mtcb          = NULL;
			break;
		}
		else
		{
			/* 塼곰 */
			mtcb->tm_next->tm_prev = mtcb->tm_prev;
			mtcb->tm_prev->tm_next = mtcb->tm_next;
			mtcb->tm_prev = NULL;
			mtcb = mtcb->tm_next;
		}

		/* ǰ١¿ųߤεͿ */
		mknl_unl_sys();		/* ƥΥå */
		mknl_loc_sys();		/* ƥΥå */
	}
	
	/* ˽᤹ */
	mknl_timout_head = mtcb;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
