#define UNICODE
#define _UNICODE
#include <windows.h>

OPENFILENAME createOpenFileName(LPTSTR fileName, size_t fileNameLength, DWORD flags, LPCTSTR filter)
{
	OPENFILENAME result;
	ZeroMemory(&result, sizeof(result));
	result.lStructSize = sizeof(OPENFILENAME);
	result.lpstrFile = fileName;
	result.nMaxFile = fileNameLength;
	result.Flags = flags;
	result.lpstrFilter = filter;
	result.nFilterIndex = 1;
	return result;
}

extern "C" void getFileNameFromOpenDialogCpp(LPTSTR fileName, size_t fileNameLength)
{
	OPENFILENAME a = createOpenFileName(
		fileName, fileNameLength, OFN_FILEMUSTEXIST, L"(*.mqo;*.mkm;*.3d)\0*.mqo;*.mkm;*.3d\0(*.*)\0*.*\0"
	);
	GetOpenFileName(&a);
}

extern "C" bool getFileNameFromSaveDialogCpp(LPTSTR fileName, size_t fileNameLength)
{
	OPENFILENAME a = createOpenFileName(fileName, fileNameLength, OFN_OVERWRITEPROMPT, L"(*.*)\0*.*\0");
	return GetSaveFileName(&a);
}

extern "C" void popSystemMenuCpp(HWND handle)
{
	POINT p;
	p.x = p.y = 0;
	ClientToScreen(handle, &p);
	PostMessage(handle, 0x0313, 0, MAKELPARAM(p.x, p.y));
}

extern "C" void messageBoxCpp(LPCTSTR msg)
{
	MessageBox(NULL, msg, L"model_viewer", 0);
}

extern "C" void setCaptionCpp(HWND handle, LPCTSTR text)
{
	SetWindowText(handle, text);
}
