package saccubus.worker.profile;

import java.io.File;

/**
 * 変換後の動画ファイルに関する情報を保持するプロファイル.
 * @author yuki
 */
public interface OutputProfile {

    /**
     * @return {@link #isConvert()}がtrueの場合に
     * 変換した動画を保存するディレクトリ.
     * {@link #isConvert()}がfalseの場合未定義.
     */
    public File getDir();

    /**
     * @return {@link #isConvert()}がtrueの場合に
     * 変換した動画のファイル名パターン.
     * {@link #isConvert()}がfalseの場合未定義.
     */
    String getFileName();

    /**
     * ファイル名パターンを置換するのに用いる情報.
     * @return {@link #isConvert()}がtrueの場合に
     * 変換した動画の動画ID.
     * {@link #isConvert()}がfalseの場合未定義.
     */
    String getVideoId();

    /**
     * ファイル名パターンを置換するのに用いる情報.
     * @return {@link #isConvert()}がtrueの場合に
     * 変換した動画のタイトル.
     * {@link #isConvert()}がfalseの場合未定義.
     */
    String getTitile();
}
