package yukihane.inqubus.config;

import java.io.File;
import saccubus.worker.profile.OutputProfile;

/**
 * コンフィグに設定された値を基にしたOutputProfile実装.
 * @author yuki
 */
public abstract class ConfigOutputProfile implements OutputProfile {
    private final File dir;
    private final String fileName;

    public ConfigOutputProfile() {
        final Config p = Config.INSTANCE;
        this.dir = new File(p.getOutputDir());
        this.fileName = p.getOutputFileNamePattern();
    }

    @Override
    public File getDir() {
        return dir;
    }

    @Override
    public String getFileName() {
        return fileName;
    }
}
