/* $Id: MediaInfo.java 57 2010-02-04 04:43:44Z yuki $ */
package yukihane.mediainfowrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaInfo {

    public static Info getInfo(File mediaInfoBin, File videoFile) throws IOException {
        String[] command = new String[]{mediaInfoBin.getPath(), videoFile.getPath()};
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String line;
        Pattern widthPattern = Pattern.compile("Width +:(.+)pixels");
        Pattern heightPattern = Pattern.compile("Height +:(.+)pixels");
        int width = -1;
        int height = -1;
        while ((line = reader.readLine()) != null) {
            Matcher widthMatcher = widthPattern.matcher(line);
            if (widthMatcher.find()) {
                String str = widthMatcher.group(1).replaceAll(" ", "");
                width = Integer.parseInt(str);
                continue;
            }

            Matcher heightMatcher = heightPattern.matcher(line);
            if (heightMatcher.find()) {
                String str = heightMatcher.group(1).replaceAll(" ", "");
                height = Integer.parseInt(str);
                continue;
            }
        }
        return new Info(width, height);
    }

    public static Size adjustSize(Info info, int maxWidth, int maxHeight) {
        int nowWidth = info.getWidth();
        int nowHeight = info.getHeight();

        if (nowWidth <= maxWidth && nowHeight <= maxHeight) {
            return new Size(nowWidth, nowHeight);
        }

        double widthRatio = calcRatio(nowWidth, maxWidth);
        double heightRatio = calcRatio(nowHeight, maxHeight);

        if (widthRatio >= heightRatio) {
            int adjustedWidth = adjust(nowWidth, widthRatio);
            int adjustedHeight = adjust(nowHeight, widthRatio);
            return new Size(adjustedWidth, adjustedHeight);
        } else {
            int adjustedWidth = adjust(nowWidth, heightRatio);
            int adjustedHeight = adjust(nowHeight, heightRatio);
            return new Size(adjustedWidth, adjustedHeight);
        }
    }

    private static double calcRatio(int now, int max) {
        return (double) now / (double) max;
    }

    private static int adjust(int size, double ratio) {
        return (int) (size / ratio);
    }
}
