﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using lib2ch.Data;

namespace lib2ch.IO
{
    class FileManager : File
    {
        public FileResult ModifieCheck(string Path, string Host, string FileName, string ETag)
        {
            FileResult fileResult = new FileResult();
            //サーバーからダウンロード
            fileResult = UrlReader(Host + FileName, -1, ETag);
            //System.Diagnostics.Debug.WriteLine("ManagerModifieCheck:" + fileResult.StatusCode);
            if (fileResult == null) return null;
            //ファイルの書き込み
            int ret = LocalWriter(Path, FileName, fileResult.Line, false);
            if (ret != 0) return null;
            return fileResult;
        }
        public FileResult RangeCheck(string Path, string Host, string FileName, string ETag)
        {
            FileResult fileResult = new FileResult();
            long firstPos;
            if (System.IO.File.Exists(Path + FileName))
                firstPos = (new System.IO.FileInfo(Path + FileName)).Length;
            else
                firstPos = 0;
            //サーバーからダウンロード
            fileResult = UrlReader(Host + FileName, (int)firstPos, ETag);
            //System.Diagnostics.Debug.WriteLine("ManagerRangeCheck:" + fileResult.StatusCode);
            //System.Diagnostics.Debug.WriteLine("ManagerRangeCheck:" + firstPos.ToString());
            //System.Diagnostics.Debug.WriteLine("ManagerRangeCheck:" + fileResult.EntityTag);
            if (fileResult == null) return null;
            //ファイルの書き込み
            int ret;
            if (firstPos == 0)
                ret = LocalWriter(Path, FileName, fileResult.Line, false);
            else
                ret = LocalWriter(Path, FileName, fileResult.Line, true);
            if (ret != 0) return null;
            return fileResult;
        }
        public FileResult StandardCheck(string Path, string Host, string FileName)
        {
            FileResult fileResult = new FileResult();
            fileResult = LocalReader(Path + FileName);
            if (fileResult == null)
            {
                //サーバーからダウンロード
                fileResult = UrlReader(Host + FileName, 0, "");
                //System.Diagnostics.Debug.WriteLine("Manager:" + fileResult.StatusCode);
                if (fileResult == null) return null;
                //ファイルの書き込み
                if (LocalWriter(Path, FileName, fileResult.Line, false) != 0) return null;
            }
            return fileResult;
        }
    }
}
