﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using lib2ch.IO;
using lib2ch.Data;

namespace lib2ch.Model
{
    public class ThreadDat
    {
        string _Path = "./Log";
        string _Dat = "/dat/";
        List<Dat> _DatList;
        FileManager _File;
        public ThreadDat()
        {
            _DatList = new List<Dat>();
            _File = new FileManager();
        }
        public Dat Get(SubjectData SubjectData)
        {
            int ret = Find(SubjectData);
            if (ret != -1) return _DatList[ret];
            Dat New = new Dat();
            New.Name = SubjectData.Name;
            New.ParentName = SubjectData.ParentName;
            New.Url = SubjectData.Url;
            New.Title = SubjectData.Title;
            New.FileName = "/" + SubjectData.FileName;
            New.Count = SubjectData.Count;
            FileResult fileResult = _File.StandardCheck(_Path + New.Directory, New.Url + _Dat, New.FileName);
            if (fileResult == null) return null;
            New.Parsing(fileResult.Line,0);
            New.ETag = fileResult.EntityTag;
            return New;
        }
        public Dat ReLoad(Dat Dat)
        {
            FileResult fileResult = _File.ModifieCheck(_Path + Dat.Directory,
                Dat.Url + _Dat, Dat.FileName,Dat.ETag);
            if (fileResult == null) return null;
            if (fileResult.Line.Count == 0) return null;
            Dat.Clear();
            Dat.Parsing(fileResult.Line,0);
            Dat.ETag = fileResult.EntityTag;
            return Dat;
        }
        public Dat RangeRead(Dat Dat)
        {
            FileResult fileResult = _File.RangeCheck(_Path + Dat.Directory,
                Dat.Url + _Dat, Dat.FileName, "");
            if (fileResult == null) return null;
            if (fileResult.Line.Count == 0) return null;
            Dat New = new Dat();
            System.Diagnostics.Debug.WriteLine("RangeRead:" + fileResult.Line.Count.ToString());
            New.Parsing(fileResult.Line,1);
            Dat.ETag = fileResult.EntityTag;
            return New;
        }
        private int Find(SubjectData SubjectData)
        {
            int index = 0;
            foreach(Dat dat in _DatList)
            {
                if (SubjectData.Title == dat.Title)
                {
                    return index;
                }
                index++;
            }
            return -1;
        }
    }
}
