using System;
using System.IO;

using NUnit.Framework;

using Uguu.IO.Csv;

namespace Uguu.IO.Csv.Test
{
    [TestFixture]
    public sealed class CsvReaderTest
    {
        private const string TEST_DATA_1 = @"foo,bar,boo
111,222,333";
        [Test]
        public void Test1()
        {
            StringReader reader = new StringReader(TEST_DATA_1);
            using (CsvReader csvReader = new CsvReader(reader))
            {Uguu.IO.Csv.Test
                // 最初の行の前。
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                
                // 1 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(3, csvReader.FieldCount);
                Assert.AreEqual(0, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("foo", csvReader[0]);
                Assert.AreEqual("bar", csvReader[1]);
                Assert.AreEqual("boo", csvReader[2]);
                try
                {
                    string value = csvReader[3];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 2 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(3, csvReader.FieldCount);
                Assert.AreEqual(1, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("111", csvReader[0]);
                Assert.AreEqual("222", csvReader[1]);
                Assert.AreEqual("333", csvReader[2]);
                try
                {
                    string value = csvReader[3];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 最後の行の後。
                Assert.IsFalse(csvReader.Read());
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
            }
        }
        private const string TEST_DATA_2 = @"111
222,222
333,333,333";
        [Test]
        public void Test2()
        {
            StringReader reader = new StringReader(TEST_DATA_2);
            using (CsvReader csvReader = new CsvReader(reader))
            {
                // 最初の行の前。
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                
                // 1 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(1, csvReader.FieldCount);
                Assert.AreEqual(0, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("111", csvReader[0]);
                try
                {
                    string value = csvReader[1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 2 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(2, csvReader.FieldCount);
                Assert.AreEqual(1, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("222", csvReader[0]);
                Assert.AreEqual("222", csvReader[1]);
                try
                {
                    string value = csvReader[2];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 3 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(3, csvReader.FieldCount);
                Assert.AreEqual(2, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("333", csvReader[0]);
                Assert.AreEqual("333", csvReader[1]);
                Assert.AreEqual("333", csvReader[2]);
                try
                {
                    string value = csvReader[3];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 最後の行の後。
                Assert.IsFalse(csvReader.Read());
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
            }
        }
        private const string TEST_DATA_3 = @"foo,bar,""boo
111,222"",333";
        [Test]
        public void Test3()
        {
            StringReader reader = new StringReader(TEST_DATA_3);
            using (CsvReader csvReader = new CsvReader(reader))
            {
                // 最初の行の前。
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                
                // 1 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(4, csvReader.FieldCount);
                Assert.AreEqual(0, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("foo", csvReader[0]);
                Assert.AreEqual("bar", csvReader[1]);
                Assert.AreEqual(@"boo
111,222", csvReader[2]);
                Assert.AreEqual("333", csvReader[3]);
                try
                {
                    string value = csvReader[4];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 最後の行の後。
                Assert.IsFalse(csvReader.Read());
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
            }
        }
        private const string TEST_DATA_4 = @"foo,bar,boo

,,,
111,222,333
";
        [Test]
        public void Test4()
        {
            StringReader reader = new StringReader(TEST_DATA_4);
            using (CsvReader csvReader = new CsvReader(reader))
            {
                // 最初の行の前。
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                
                // 1 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(3, csvReader.FieldCount);
                Assert.AreEqual(0, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("foo", csvReader[0]);
                Assert.AreEqual("bar", csvReader[1]);
                Assert.AreEqual("boo", csvReader[2]);
                try
                {
                    string value = csvReader[3];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 2 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(0, csvReader.FieldCount);
                Assert.AreEqual(1, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 3 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(4, csvReader.FieldCount);
                Assert.AreEqual(2, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("", csvReader[0]);
                Assert.AreEqual("", csvReader[1]);
                Assert.AreEqual("", csvReader[2]);
                Assert.AreEqual("", csvReader[3]);
                try
                {
                    string value = csvReader[4];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 4 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(3, csvReader.FieldCount);
                Assert.AreEqual(3, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                Assert.AreEqual("111", csvReader[0]);
                Assert.AreEqual("222", csvReader[1]);
                Assert.AreEqual("333", csvReader[2]);
                try
                {
                    string value = csvReader[3];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 5 行目。
                Assert.IsTrue(csvReader.Read());
                
                Assert.AreEqual(0, csvReader.FieldCount);
                Assert.AreEqual(4, csvReader.RowCount);
                
                try
                {
                    string value = csvReader[-1];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (IndexOutOfRangeException)
                {
                }
                
                // 最後の行の後。
                Assert.IsFalse(csvReader.Read());
                try
                {
                    int fieldCount = csvReader.FieldCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    int rowCount = csvReader.RowCount;
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
                try
                {
                    string value = csvReader[0];
                    Assert.Fail();
                }
                catch (InvalidOperationException)
                {
                }
            }
        }
    }
}
