﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace CTester
{
    /// <summary>
    /// DialogVersion.xaml の相互作用ロジック
    /// </summary>
    public partial class DialogVersion : Window
    {
        public DialogVersion()
        {
            InitializeComponent();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            System.Reflection.Assembly asm =
                System.Reflection.Assembly.GetExecutingAssembly();
            

            System.Reflection.AssemblyCopyrightAttribute asmcpy =
                (System.Reflection.AssemblyCopyrightAttribute)
                Attribute.GetCustomAttribute(
                System.Reflection.Assembly.GetExecutingAssembly(),
                typeof(System.Reflection.AssemblyCopyrightAttribute));
            textBlockCopyright.Text = asmcpy.Copyright;

            //AssemblyTitleの取得
            System.Reflection.AssemblyTitleAttribute asmttl =
                (System.Reflection.AssemblyTitleAttribute)
                Attribute.GetCustomAttribute(
                    System.Reflection.Assembly.GetExecutingAssembly(),
                    typeof(System.Reflection.AssemblyTitleAttribute));
            this.Title = asmttl.Title + "のバージョン情報";

            //バージョンの取得
            System.Version ver = asm.GetName().Version;
            textBlockVesion.Text = "バージョン " + ver.ToString();

            //AssemblyDescriptionの取得
            System.Reflection.AssemblyDescriptionAttribute asmdc =
                (System.Reflection.AssemblyDescriptionAttribute)
                Attribute.GetCustomAttribute(
                System.Reflection.Assembly.GetExecutingAssembly(),
                typeof(System.Reflection.AssemblyDescriptionAttribute));
            textBlockDescription.Text = asmdc.Description.ToString();
        }

        private void buttonOk_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = true;
        }
    }
}
