﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using CTester.Setting;

namespace CTester.Emulator
{
    /// <summary>
    /// WindowEmulator.xaml の相互作用ロジック
    /// </summary>
    public partial class PanelEmulator : AvalonDock.DockableContent
    {
        Project _project;

        public PanelEmulator()
        {
            InitializeComponent();
        }

        public void Initialize(Project project)
        {
            _project = project;
            _project.ChangedInfo += project_ChangeInfo;

        }

        private void project_ChangeInfo(object sender, EventArgs e)
        {
            gridEmulator.Children.Clear();

            var emuSetting = _project.EmuSetting;
            double top = 12;
            foreach (var item in emuSetting.ButtonSettings)
            {
                Button button = new Button();
                button.Content = item.Name;
                button.Height = item.Size.Height;
                button.Width = item.Size.Width;
                button.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
                button.Margin = new Thickness(item.Position.X, item.Position.Y, 0, 0);
                button.VerticalAlignment = System.Windows.VerticalAlignment.Top;
                button.PreviewMouseLeftButtonDown += button_PreviewMouseLeftButtonDown;
                button.PreviewMouseLeftButtonUp += button_PreviewMouseLeftButtonUp;
                button.Tag = item;
                gridEmulator.Children.Add(button);

                top += 24;
            }
        }
        private void button_PreviewMouseLeftButtonDown(object sender, RoutedEventArgs e)
        {
            Button button = sender as Button;
            EmuButtonSetting setting = button.Tag as EmuButtonSetting;
            EmuEventSetting buttonOn = setting.ButtonOn;

            //ExParam inExParam = new ExParam();
            //ExParam outExParam = new ExParam();

            button.CaptureMouse();
            char[] data = new char[10];
            data[0] = (char)1;
            data[1] = (char)2;
            ExParam param = new ExParam();
            param.data[0] = 1;
            param.data[1] = 2;

            string outData;
            //_project.Source.ExecTDDriver(
            //    buttonOn.DriverNo, 
            //    buttonOn.DriverParam,
            //    "12",out outData);
        }

        private void button_PreviewMouseLeftButtonUp(object sender, MouseButtonEventArgs e)
        {
            Button button = sender as Button;
            EmuButtonSetting setting = button.Tag as EmuButtonSetting;
            EmuEventSetting buttonOff = setting.ButtonOff;

            ExParam inExParam = new ExParam();
            ExParam outExParam = new ExParam();

            if (button.IsMouseCaptured)
            {
                button.ReleaseMouseCapture();
            }
        }


    }
}
