﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Collections.ObjectModel;
using CTester.Setting;

namespace CTester.Emulator.Property
{
    /// <summary>
    /// UcEmuButtonSetting.xaml の相互作用ロジック
    /// </summary>
    public partial class UcEmuButtonSetting : UserControl
    {
        //Project _project;
        EmuSetting _emuSetting;
        //private List<EmuButtonSetting> _buttonSettings=new List<EmuButtonSetting>();

        //public List<EmuButtonSetting> ButtonSettings
        //{
        //    get
        //    {
        //        return _buttonSettings;
        //    }
        //}

        public UcEmuButtonSetting()
        {
            InitializeComponent();
        }

        public void Initialize(EmuSetting emuSetting)
        {
            _emuSetting = emuSetting;

            //@@ToDo:設定のコピーを作成しなければプロパティグリッドで直接編集されてしまう。
            //------------------------------------------------------
            listBoxEmuButton.DataContext = _emuSetting.ButtonSettings;
        }

        private void buttonUp_Click(object sender, RoutedEventArgs e)
        {

        }

        private void buttonDown_Click(object sender, RoutedEventArgs e)
        {

        }

        private void buttonDelete_Click(object sender, RoutedEventArgs e)
        {
            if (listBoxEmuButton.SelectedIndex >= _emuSetting.ButtonSettings.Count || listBoxEmuButton.SelectedIndex < 0)
            {
                return;
            }
            _emuSetting.ButtonSettings.RemoveAt(listBoxEmuButton.SelectedIndex);

        }

        private void buttonAdd_Click(object sender, RoutedEventArgs e)
        {
            var buttonSetting = new EmuButtonSetting();
            _emuSetting.ButtonSettings.Add(buttonSetting);
            listBoxEmuButton.DataContext = null;
            listBoxEmuButton.DataContext = _emuSetting.ButtonSettings;
        }

        private void listBoxEmuButton_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            var property = listBoxEmuButton.SelectedItem as EmuButtonSetting;
            if (property != null)
            {
                propertyGrid.SelectedObject = property;
            }
        }
    }
}
