﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Windows.Navigation;
using Utility;

namespace CTester.NewProject
{
    /// <summary>
    /// DialogNewProject.xaml の相互作用ロジック
    /// </summary>
    public partial class DialogNewProject : Window
    {
        private NewProjectInfo _newProjectInfo = new NewProjectInfo();

        public string ProjectFolder 
        { 
            get
            {
                return _newProjectInfo.ProjectFolder;
            }
        }

        public string ProjectName
        {
            get
            {
                return _newProjectInfo.ProjectName;
            }
        }

        public string SourcePath
        {
            get
            {
                return _newProjectInfo.SourcePath;
            }
        }

        public DialogNewProject()
        {
            InitializeComponent();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            PageProject pagePrj = new PageProject(_newProjectInfo);
            WizardLancher lancher = new WizardLancher(pagePrj);
            lancher.WizardReturn += wizardLauncher_WizardReturn;
            frameMain.Navigate(lancher);
        }

        private void wizardLauncher_WizardReturn(object sender, ReturnEventArgs<WizardResult> e)
        {
            switch(e.Result)
            {
                case WizardResult.Finished:
                    DialogResult = true;
                    break;
                default:
                    DialogResult = false;
                    break;
            }
            Close();
        }
    }

    public class NewProjectInfo
    {
        public string ProjectFolder = string.Empty;
        public string ProjectName = string.Empty;
        public string SourcePath = string.Empty;
    }

}
