﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.IO;
using Microsoft.Win32;
using Utility;
using CTester.Command;

namespace CTester.NewProject
{
    /// <summary>
    /// PageProject.xaml の相互作用ロジック
    /// </summary>
    public partial class PageProject : PageFunction<WizardResult>
    {

        NewProjectInfo _newProjectInfo;
        public PageProject(NewProjectInfo newProjectInfo)
        {
            InitializeComponent();

            _newProjectInfo = newProjectInfo;
            this.DataContext = _newProjectInfo;
        }

        private void buttonReference_Click(object sender, RoutedEventArgs e)
        {
            var dlg = new System.Windows.Forms.FolderBrowserDialog();

            dlg.Description = "プロジェクト作成するフォルダを指定してください。";
            if (dlg.ShowDialog() == System.Windows.Forms.DialogResult.OK)
            {
                textBoxFolder.Text = dlg.SelectedPath;
            }
        }

        private void buttonNext_Click(object sender, RoutedEventArgs e)
        {
            var folder = textBoxFolder.Text;
            var name = textBoxProjectName.Text.Trim();

            if (!Directory.Exists(folder))
            {
                MessageBox.Show("ディレクトリが存在しません。", "エラー", MessageBoxButton.OK);
                return;
            }

            if (name == string.Empty)
            {
                MessageBox.Show("プロジェクト名が不正です。", "エラー", MessageBoxButton.OK);
                return;
            }

            _newProjectInfo.ProjectFolder = folder;
            _newProjectInfo.ProjectName = name;

            var pageSource = new PageSource(_newProjectInfo);
            pageSource.Return += wizardPage_Return;
            NavigationService.Navigate(pageSource);
        }

        private void buttonCancel_Click(object sender, RoutedEventArgs e)
        {
            
            OnReturn(new ReturnEventArgs<WizardResult>(WizardResult.Canceled));
        }

        public void wizardPage_Return(object sender, ReturnEventArgs<WizardResult> e)
        {
            // If returning, wizard was completed (finished or canceled),
            // so continue returning to calling page
            OnReturn(e);
        }
    
    }


}
