﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using System.Windows;
using System.ComponentModel;
using CTester.Command;
using CTester.Common;
using Utility;

namespace CTester.UnitTest.Command
{
    /// <summary>
    /// 単体テストランコマンド
    /// </summary>
    public class CommandUnitTestRun : CommandBase
    {
        UTRoot _root;
        UIElement _owner;

        //public event PropertyChangedEventHandler PropertyChanged;

        //protected void OnPropertyChanged(string name)
        //{
        //    if (PropertyChanged != null)
        //    {
        //        PropertyChanged(this, new PropertyChangedEventArgs(name));
        //    }
        //}

        public enum StatusEnum : int
        {
            Init,
            Exec,
            Completed,
        }

        private StatusEnum _status = StatusEnum.Init;
        public StatusEnum Status
        {
            get
            {
                return _status;
            }
            private set
            {
                _status = value;
                OnTestRunStatusChanged();
            }
        }

        public event EventHandler TestRunStatusChanged;

        protected void OnTestRunStatusChanged()
        {
            if (TestRunStatusChanged != null)
            {
                TestRunStatusChanged(this, new EventArgs());
            }
        }


        public event EventHandler TestItemCompleted;

        protected void OnTestItemCompleted(object sender)
        {
            if (TestItemCompleted != null)
            {
                TestItemCompleted(sender, new EventArgs());
            }
        }


        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="owner"></param>
        /// <param name="root"></param>
        public CommandUnitTestRun(UIElement owner, UTRoot root)
            : base()
        {
            _owner = owner;
            _root = root;
        }

        /// <summary>
        /// 実行可能
        /// </summary>
        /// <param name="parameter"></param>
        /// <returns></returns>
        public override bool CanExecute(object parameter)
        {
            if (_root.SearchSelectedItem() == null)
            {
                return false;
            }
            return true;
        }

        /// <summary>
        /// 実行
        /// </summary>
        /// <param name="parameter"></param>
        public override void Execute(object parameter)
        {
            Status = StatusEnum.Exec;
            
            int finishedCount = 0;
            var dlg = new DialogProgress("単体テスト実行中");
            _root.ClearResult();

            Action<UTTest> execTest = new Action<UTTest>((test) =>
            {
                if (dlg.IsCancelRequire)
                {
                    return;
                }
                
                _owner.Dispatcher.BeginInvoke(new Action(() =>
                {
                    test.ExecTest();
                    OnTestItemCompleted(test);
                }));
                Thread.Sleep(10);

                finishedCount += 1;
                dlg.FinishedCount = finishedCount;
            });

            Action<UTGroup> execGroup = new Action<UTGroup>((group) =>
            {
                foreach (var test in group.Children)
                {
                    if (dlg.IsCancelRequire)
                    {
                        break;
                    }

                    execTest(test);
                }
                if (group.Children.Any((x) => x.TestResult == UTResultEnum.NG))
                {
                    group.TestResult = UTResultEnum.NG;
                }
                else if (group.Children.Any((x) => x.TestResult == UTResultEnum.Non))
                {
                    group.TestResult = UTResultEnum.Non;
                }
                else
                {
                    group.TestResult = UTResultEnum.OK;
                }
            });

            Action<UTGroups> execGroups = new Action<UTGroups>((groups) =>
            {
                foreach (var group in groups.Children)
                {
                    if (dlg.IsCancelRequire)
                    {
                        break;
                    }

                    execGroup(group);
                }
                if (groups.Children.Any((x) => x.TestResult == UTResultEnum.NG))
                {
                    groups.TestResult = UTResultEnum.NG;
                }
                else if (groups.Children.Any((x) => x.TestResult == UTResultEnum.Non))
                {
                    groups.TestResult = UTResultEnum.Non;
                }
                else
                {
                    groups.TestResult = UTResultEnum.OK;
                }
            });

            var selectedItem = _root.SearchSelectedItem();

            dlg.TotalCount = selectedItem.TestCount;
            var result = dlg.ShowDialog(new Action(() =>
                {
                    Type type = selectedItem.GetType();
                    if (type == typeof(UTTest))
                    {
                        execTest((UTTest)selectedItem);
                    }
                    else if (type == typeof(UTGroup))
                    {
                        execGroup((UTGroup)selectedItem);
                    }
                    else if (type == typeof(UTGroups))
                    {
                        execGroups((UTGroups)selectedItem);
                    }
                }));

            if (result.HasValue && !result.Value)
            {
                MessageBox.Show("キャンセルされました。", "キャンセル", MessageBoxButton.OK);
            }

            Status = StatusEnum.Completed;
        }
    }
}
