﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Runtime.InteropServices;
using System.ComponentModel;
using System.Threading;
using System.Threading.Tasks;
using CTester.Setting;
using CTester.UnitTest.Command;
using Utility;

namespace CTester.UnitTest
{
    /// <summary>
    /// WindowUnitTest.xaml の相互作用ロジック
    /// </summary>
    public partial class PanelUnitTest : AvalonDock.DockableContent
    {
        private Project _project = null;
        //private UTRoot _root = new UTRoot();
        private UTRoot _root = new UTRoot();
        //private BackgroundWorker _backgroundWorker = null;

        public PanelUnitTest()
        {
            InitializeComponent();
        }

        public void Initialize(Project project)
        {
            _project = project;
            _project.ChangedInfo += project_ChangeInfo;

            var commandRun = new CommandUnitTestRun(this, _root);
            App.Commands.Add(commandRun);

            DataContext = _root;
            buttonRun.Command = App.Commands[typeof(CommandUnitTestRun)];
            UpdateTree();

            commandRun.TestItemCompleted += new EventHandler(commandRun_TestItemCompleted);
            commandRun.TestRunStatusChanged += new EventHandler(commandRun_TestRunStatusChanged);
        }

        void commandRun_TestRunStatusChanged(object sender, EventArgs e)
        {
            var cmd = sender as CommandUnitTestRun;
            if (cmd.Status == CommandUnitTestRun.StatusEnum.Exec)
            {
                listBoxError.Items.Clear();
            }
        }

        void commandRun_TestItemCompleted(object sender, EventArgs e)
        {
            var test = sender as UTTest;
            if (test.TestResult == UTResultEnum.NG)
            {
                listBoxError.Items.Add(test.Message);
            }
        }

        private void project_ChangeInfo(object sender, EventArgs e)
        {
            UpdateTree();
        }

        private void UpdateTree()
        {
            _root.Children.Clear();

            UTGroups groups = new UTGroups();
            groups.Children.Clear();

            var source = _project.Source;
            if(source == null)
            {
                return;
            }

            string groupName = string.Empty;
            string funcName = string.Empty;
            UTGroup group;
            UTTest test;
            int count = source.UT_GetTestCount();
            for(int i = 0;i<count;i++)
            {
                groupName = source.GetUTFileName(i);
                funcName = source.GetUTFuncName(i);
                if (!groups.Children.Any((x) => x.Name == groupName))
                {
                    group = new UTGroup(groupName);
                    group.IsExpanded = true;
                    groups.Children.Add(group);
                }
                else
                {
                    group = groups.Children.First((x) => x.Name == groupName);
                }

                if (group != null)
                {
                    test = new UTTest(source, funcName, i);
                    group.Children.Add(test);
                }
            }
            groups.IsExpanded = true;
            _root.Children.Add(groups);
        }
    }
}
