﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace CTester.UnitTest
{
    public class UTGroup : INotifyPropertyChanged,IUTTest
    {
        // ----------------------------------------
        // プロパティ
        // ----------------------------------------
        #region Properties

        protected ObservableCollection<UTTest> _children = new ObservableCollection<UTTest>();
        public ObservableCollection<UTTest> Children
        {
            get
            {
                return _children;
            }
            set
            {
                _children = value;
            }
        }

        protected string _name = string.Empty;
        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                _name = value;
                OnPropertyChanged("Name");
            }
        }

        protected bool _isExpaned = true;
        public bool IsExpanded
        {
            get
            {
                return _isExpaned;
            }
            set
            {
                _isExpaned = value;
                this.OnPropertyChanged("IsExpanded");
            }
        }

        #endregion

        // ----------------------------------------
        // INotifyPropertyChangedインターフェース
        // ----------------------------------------
        #region INotifyPropertyChanged InterFace

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        // ----------------------------------------
        // IUTTestインターフェース
        // ----------------------------------------
        #region IUTTestInterFace

        protected UTResultEnum _testResult = UTResultEnum.Non;
        public UTResultEnum TestResult
        {
            get
            {
                return _testResult;
            }
            set
            {
                _testResult = value;
                this.OnPropertyChanged("TestResult");
            }
        }

        public int TestCount
        {
            get
            {
                return _children.Count;
            }
        }

        public List<UTTest> GetTestList()
        {
            return _children.ToList();
        }

        public void ExecTest()
        {
            foreach (var child in _children)
            {
                child.ExecTest();
            }

            if (_children.Any((x) => x.TestResult == UTResultEnum.NG))
            {
                TestResult = UTResultEnum.NG;
            }
            else
            {
                TestResult = UTResultEnum.OK;
            }
        }

        public void ClearResult()
        {
            foreach (var child in _children)
            {
                child.ClearResult();
            }
            TestResult = UTResultEnum.Non;
        }

        protected bool _isSelected = false;
        public bool IsSelected
        {
            get
            {
                return _isSelected;
            }


            set
            {
                _isSelected = value;
                this.OnPropertyChanged("IsSelected");
            }
        }


        #endregion

        // ----------------------------------------
        // コンストラクタ
        // ----------------------------------------
        #region Constructor

        public UTGroup(string name)
        {
            _name = name;
        }

        #endregion

        // ----------------------------------------
        // メソッド
        // ----------------------------------------
        #region Methods

        public IUTTest SearchSelectedItem()
        {
            if (IsSelected)
            {
                return this;
            }

            if (_children.Any((x) => x.IsSelected))
            {
                return _children.First((x) => x.IsSelected);
            }

            return null;
        }

        #endregion
    }
}
