﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Runtime.InteropServices;
using CTester.Setting;

namespace CTester.UnitTest
{
    public enum UTResultEnum : int
    {
        Non,	// 未実施
        OK,		// ＯＫ
        NG,		// ＮＧ
    };

    public interface IUTTest
    {
        UTResultEnum TestResult{get;}
        int TestCount { get; }
        void ExecTest();
        void ClearResult();
        List<UTTest> GetTestList();
        bool IsSelected { get; set; }
    }

    public class UTTest : INotifyPropertyChanged, IUTTest
    {
        private ITesterSource _source = null;
        private int _testNo = -1;

        // ----------------------------------------
        // プロパティ
        // ----------------------------------------
        #region Properties

        protected string _name = string.Empty;
        public string Name
        {
            get
            {
                return _name;
            }
            set
            {
                _name = value;
                OnPropertyChanged("Name");
            }
        }

        protected string _message = string.Empty;
        public string Message 
        {
            get
            {
                return _message;
            }
            set
            {
                _message = value;
            }
        }

        #endregion

        // ----------------------------------------
        // INotifyPropertyChangedインターフェース
        // ----------------------------------------
        #region INotifyPropertyChanged InterFace

        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(string name)
        {
            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs(name));
            }
        }

        #endregion

        // ----------------------------------------
        // IUTTestインターフェース
        // ----------------------------------------
        #region IUTTestInterFace

        protected UTResultEnum _testResult = UTResultEnum.Non;
        public UTResultEnum TestResult
        {
            get
            {
                return _testResult;
            }
            set
            {
                _testResult = value;
                this.OnPropertyChanged("TestResult");
            }
        }

        public int TestCount
        {
            get
            {
                return 1;
            }
        }

        public List<UTTest> GetTestList()
        {
            var list = new List<UTTest>();
            list.Add(this);
            return list;
        }

        public void ExecTest()
        {
            int result = _source.UT_ExecTest(_testNo);
            UTResultEnum testResult = (UTResultEnum)result;

            if (testResult == UTResultEnum.NG)
            {
                //_message = GetUTMessage(_testNo);
                _message = _source.GetUTMessage(_testNo);
            }

            TestResult = testResult;
        }

        public void ClearResult()
        {
            _message = string.Empty;
            TestResult = UTResultEnum.Non;
        }

        protected bool _isSelected = false;
        public bool IsSelected
        {
            get
            {
                return _isSelected;
            }


            set
            {
                _isSelected = value;
                this.OnPropertyChanged("IsSelected");
            }
        }

        #endregion

        // ----------------------------------------
        // コンストラクタ
        // ----------------------------------------
        #region Constructor

        public UTTest(ITesterSource source,string name,int testNo)
        {
            _source = source;
            _name = name;
            _testNo = testNo;
        }

        #endregion

        // ----------------------------------------
        // メソッド
        // ----------------------------------------
        #region Methods


        #endregion
    }
}
