﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Navigation;

namespace Utility
{
    public enum WizardResult
    {
        Finished,
        Canceled
    }

    public class WizardLancher : PageFunction<WizardResult>
    {
        public event ReturnEventHandler<WizardResult> WizardReturn;

        PageFunction<WizardResult> _startPage;

        public WizardLancher(PageFunction<WizardResult> startPage)
        {
            _startPage = startPage;
        }

        protected override void Start()
        {
            base.Start();

            // So we remember the WizardCompleted event registration
            this.KeepAlive = true;

            // Launch the wizard
            _startPage.Return += new ReturnEventHandler<WizardResult>(wizardPage_Return);
            this.NavigationService.Navigate(_startPage);
        }

        public void wizardPage_Return(object sender, ReturnEventArgs<WizardResult> e)
        {
            // Notify client that wizard has completed
            // NOTE: We need this custom event because the Return event cannot be
            // registered by window code - if WizardDialogBox registers an event handler with
            // the WizardLauncher's Return event, the event is not raised.
            if (this.WizardReturn != null)
            {
                this.WizardReturn(this, e);
            }
            OnReturn(null);
        }

    }
}
