﻿using System;
namespace D2DBench
{
    interface IRender
    {
        void BeginDraw();
        int ColorCount { get; }
        void Dispose();
        void DrawBitmap(IBitmap bmp, int left, int top, int right, int bottom);
        void DrawRectangle(int left, int top, int right, int bottom, int colorno);
        void DrawString(int x, int y, int colorno);
        void EndDraw();
        void FillRectangle(int left, int top, int right, int bottom, int colorno);
        void DrawEllipse(int x, int y, int radiusX, int radiusY, int colorno);
        void DrawRectangleByBrush(int left, int top, int right, int bottom, int colorno,int backcolorno);
        void DrawEllipseByBrush(int x, int y, int radiusX, int radiusY, int colorno, int backcolorno);
        IBitmap Load(System.Drawing.Bitmap srcBitmap);
        void UnLoad(IBitmap bmp);
    }
    interface IBitmap
    {
        int Width { get; }
        int Height { get; }
    }
}
