﻿using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using SharpDX;
using SharpDX.Direct2D1;
using SharpDX.DirectWrite;

using D2D = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;
using Drawing = System.Drawing;

namespace D2DBench
{
    class Method1 : IBench
    {
        public int fillAreaSize { get { return 0; } }
        public string methodName { get { return "文字列"; } }
        public int loopCount { get; set; }

        IRender d2d;
        Drawing.Size ClientSize;
        Random rnd;

        public void Init(Control ctrl, bool antialias,RenderMethod method)
        {
            ClientSize = ctrl.ClientSize;
            if (method == RenderMethod.Direct2D)
                this.d2d = new Direct2D(ctrl, ClientSize, antialias);
            else
                this.d2d = new GDI(ctrl);
            rnd = new Random();
        }

        public void Exec()
        {
            this.d2d.BeginDraw();
            for (int i = 0; i < this.loopCount; i++)
            {
                this.d2d.DrawString(rnd.Next(ClientSize.Width), rnd.Next(ClientSize.Height), rnd.Next(this.d2d.ColorCount - 1));
            }
            this.d2d.EndDraw();
        }

        public void Dispose()
        {
            this.d2d.Dispose();
        }
    }
}
