﻿using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Diagnostics;
using System.Windows.Forms;
using D2DBench.Properties;
using SharpDX;
using SharpDX.Direct2D1;
using SharpDX.DirectWrite;
using System.Runtime.InteropServices;

using D2D1 = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;
using Drawing = System.Drawing;

namespace D2DBench
{
    class Method4 : IBench
    {
        public int fillAreaSize { get { return bmp.Width * bmp.Height * this.loopCount; } }
        public string methodName { get { return "BitBlt"; } }
        public int loopCount { get; set; }

        Drawing.Size ClientSize;
        Random rnd;
        IRender d2d;
        IBitmap bmp;

        public void Init(Control ctrl, bool antialias, RenderMethod method)
        {
            ClientSize = ctrl.ClientSize;
            if (method == RenderMethod.Direct2D)
                this.d2d = new Direct2D(ctrl, ClientSize, antialias);
            else
                this.d2d = new GDI(ctrl);
            this.bmp = this.d2d.Load(Resources.image);
            rnd = new Random();
        }

        public void Dispose()
        {
            this.d2d.UnLoad(this.bmp);
            this.d2d.Dispose();
        }

        public void Exec()
        {
            this.d2d.BeginDraw();
            for (int i = 0; i < this.loopCount; i++)
            {
                int left = rnd.Next(ClientSize.Width);
                int top = rnd.Next(ClientSize.Height);
                this.d2d.DrawBitmap(bmp,
                    left,
                    top,
                    left + bmp.Width,
                    top + bmp.Height);
            }
            this.d2d.EndDraw();
        }
    }
}
