﻿using System;
using System.Drawing;
using System.Drawing.Imaging;
using System.Diagnostics;
using System.Windows.Forms;
using D2DBench.Properties;
using SharpDX;
using SharpDX.Direct2D1;
using SharpDX.DirectWrite;
using System.Runtime.InteropServices;

using D2D1 = SharpDX.Direct2D1;
using DW = SharpDX.DirectWrite;
using Drawing = System.Drawing;

namespace D2DBench
{
    class Method5 : IBench
    {
        public int fillAreaSize { get { return 0; } }
        public string methodName { get { return "円"; } }
        public int loopCount { get; set; }

        Drawing.Size ClientSize;
        Random rnd;
        IRender d2d;

        public void Init(Control ctrl, bool antialias, RenderMethod method)
        {
            ClientSize = ctrl.ClientSize;
            if (method == RenderMethod.Direct2D)
                this.d2d = new Direct2D(ctrl, ClientSize, antialias);
            else
                this.d2d = new GDI(ctrl);
            rnd = new Random();
        }

        public void Dispose()
        {
            this.d2d.Dispose();
        }

        public void Exec()
        {
            int radius = Form1.FigureHeight/2;
            this.d2d.BeginDraw();
            for (int i = 0; i < this.loopCount; i++)
            {
                this.d2d.DrawEllipse(rnd.Next(ClientSize.Width), rnd.Next(ClientSize.Height), radius, radius, rnd.Next(this.d2d.ColorCount - 1));
            }
            this.d2d.EndDraw();
        }
    }
}
