/*
 * D2DX
 * Copyright (C) SatisKia. All rights reserved.
 */

#include <windows.h>

#include "_Vector.hpp"

#include "_Object.hpp"

_Vector::_Vector()
{
	_object = NULL;
	_size = 0;
}

_Vector::~_Vector()
{
	removeAllElements();
}

void _Vector::addElement( _Object* object )
{
	int i;
	_Object** tmp = (_Object**)GlobalAlloc( GMEM_FIXED, sizeof(_Object*) * (_size + 1) );
	for( i = 0; i < _size; i++ )
	{
		tmp[i] = _object[i];
	}
	tmp[i] = object;
	if( _object != NULL )
	{
		GlobalFree( _object );
	}
	_object = tmp;
	_size++;
}

void _Vector::setElementAt( _Object* object, int index )
{
	if( (index >= 0) && (index < _size) )
	{
		delete _object[index];
		_object[index] = object;
	}
}

void _Vector::insertElementAt( _Object* object, int index )
{
	if( (index >= 0) && (index < _size) )
	{
		int i;
		_Object** tmp = (_Object**)GlobalAlloc( GMEM_FIXED, sizeof(_Object*) * (_size + 1) );
		for( i = 0; i < index; i++ )
		{
			tmp[i] = _object[i];
		}
		for( i = (_size - 1); i >= index; i-- )
		{
			tmp[i + 1] = _object[i];
		}
		tmp[index] = object;
		if( _object != NULL )
		{
			GlobalFree( _object );
		}
		_object = tmp;
		_size++;
	}
}

void _Vector::removeElementAt( int index )
{
	int i;
	if( (index < 0) || (index >= _size) )
	{
		return;
	}
	delete _object[index];
	for( i = index; i < (_size - 1); i++ )
	{
		_object[i] = _object[i + 1];
	}
	_size--;
	if( _size == 0 )
	{
		GlobalFree( _object );
		_object = NULL;
	}
}

void _Vector::removeAllElements()
{
	int i;
	if( _size > 0 )
	{
		for( i = 0; i < _size; i++ )
		{
			delete _object[i];
		}
		GlobalFree( _object );
		_object = NULL;
		_size = 0;
	}
}

_Object* _Vector::elementAt( int index )
{
	if( (index < 0) || (index >= _size) )
	{
		return NULL;
	}
	return _object[index];
}

_Object* _Vector::firstElement()
{
	return _object[0];
}

_Object* _Vector::lastElement()
{
	return _object[_size - 1];
}

BOOL _Vector::isEmpty()
{
	return (_size == 0) ? TRUE : FALSE;
}
