/****************************************************
 * R a y  S p e e d e r                             *
 * Copyright (C) SatisFactory. All rights reserved. *
 ****************************************************/

#include "_Global.h"

#include "_Vector.hpp"

#include "Stage.hpp"

#include "Star.hpp"

#define m g_main
#define g g_main->g

/**
 * RXgN^
 */
Stage::Stage() {
	_back = -1;
	star = new _Vector();
}

/**
 * fXgN^
 */
Stage::~Stage() {
	delete star;
}

/**
 * Xe[Wf[^\z
 */
void Stage::create() {
	int i;

	star->removeAllElements();

	int tmp;
	for ( ; ; ) {
		tmp = (m->_rand->nextInt() % 4) + 3;
		if ( tmp != _back ) {
			_back = tmp;
			break;
		}
	}

	_col = (m->_rand->nextInt() % 2) + 1;

	// V[hύX
	if ( m->level == 5 ) {
		m->speeder[0]->shield(_col);
	}
	if ( (m->level < 2) || (m->level == 7) ) {
		m->speeder[1]->shield(_col);
		m->speeder[2]->shield(_col);
	}

	for ( i = 0; i < 480; i++ ) {
		star->addElement(new Star(320 + (m->_rand->nextInt() % 960), i));
	}

	m->wave->add_bar(-200, 384, 3, (m->level != 6) ? 9 : 0, FALSE);
	bar = 1;
	for ( i = 344; i > 0; i -= 40 ) {
		m->wave->add_bar(-200, i, _col);
		bar++;
	}

	old_distance = m->speeder[0]->distance();
	x            = -200;
	_move_x      = 0;
	_offset_x    = 0;
	counter      = FALSE;
}

/**
 * Xe[Wf[^XV
 */
void Stage::update() {
	int i;

	for ( i = star->size() - 1; i >= 0; i-- ) {
		Star* tmp = (Star*)star->elementAt(i);
		if ( !tmp->update() ) {
			star->removeElementAt(i);
		}
	}

	if ( m->speeder[0]->speed() > 0 ) {
		star->addElement(new Star(320 + (m->_rand->nextInt() % 960), 0));
	}

	if ( m->level != 6 ) {
		for ( i = 0; i < 3; i++ ) {
			if (
			((i == 0) && m->wave->clear()) ||
			((i != 0) && (m->speeder[i]->distance() > (DISTANCE + 2400)))
			) {
				m->speeder[i]->speed_down(20);
			} else {
				m->speeder[i]->speed_up(1);
			}
			m->speeder[i]->add_distance(m->speeder[i]->speed());
			if ( (m->level >= 2) && (m->level <= 6) ) break;
		}
	} else {
		if ( m->speeder[0]->speed() < 500 ) {
			m->speeder[0]->speed_down(5);
		}
		m->speeder[0]->add_distance(m->speeder[0]->speed());
	}

	if ( counter ) {
		if ( (m->speeder[0]->distance() - old_distance) >= 500 ) {
			m->wave->add_bar(x, 0, 3, 9 - _counter, FALSE);
			bar++;
			if ( bar >= 12 ) {
				bar = 0;
				counter = FALSE;
			}
			old_distance = m->speeder[0]->distance();
		}
	} else {
		if ( bar > 24 ) {
			bar = 0;

			m->change_col = (m->level == 7) ? 1 : 2;

			switch ( m->level ) {
			case 0:
			case 2:
			case 4:
				_move_x += (12 * (m->_rand->nextInt() % 2));
				if ( _move_x < -12 ) _move_x = -12;
				if ( _move_x >  12 ) _move_x =  12;
				break;
			case 1:
			case 3:
			case 5:
			case 6:
				_move_x += (12 * (m->_rand->nextInt() % 3));
				if ( _move_x < -24 ) _move_x = -24;
				if ( _move_x >  24 ) _move_x =  24;
				break;
			case 7:
				_offset_x = (200 * (m->_rand->nextInt() % 2));
				break;
			}
		} else if ( (m->level == 7) && (bar > 5) ) {
			if ( m->change_col == 1 ) m->change_col = 2;

			x += _offset_x;
			_offset_x = 0;
		}

		if ( m->change_col == 2 ) {
			m->change_col = 0;

			int old_col = _col;
			_col = (m->_rand->nextInt() % 2) + 1;
			if ( _col != old_col ) {
				if ( (m->level < 2) || (m->level == 7) ) {
					// V[h؂ւxvJn
					m->_elapse_s = 1;

					// V[hύX
					for ( i = 0; i < 2; i++ ) {
						if ( m->shield_wait[i] == 0 ) {
							m->shield_wait[i] = m->shield_lag[i];
							m->shield_col [i] = _col;
						}
					}
				}
			}
		}

		if ( (m->speeder[0]->distance() - old_distance) >= 500 ) {
			if ( m->level != 6 ) {
				_counter = m->speeder[0]->distance() / (DISTANCE / 9);
				if ( _counter != (old_distance / (DISTANCE / 9)) ) {
					m->wave->add_bar(x, 0, 3, 9 - _counter, TRUE);
					if ( (9 - _counter) > 0 ) {
						bar = 1;
						if ( _counter == 4 ) {
m->play_music(BGM_SLOWLY);
						} else if ( _counter == 7 ) {
m->play_music(BGM_SPEEDY);
						}
						counter = TRUE;
						if ( (m->level < 2) || (m->level == 7) ) {
							m->boost = TRUE;
						}
					}
				} else if ( m->speeder[0]->distance() < DISTANCE ) {
					bar += (m->speeder[0]->distance() - old_distance) / 500;
					x += _move_x;
					m->wave->add_bar(x, 0, _col);
				}
			} else {
				bar += (m->speeder[0]->distance() - old_distance) / 500;
				x += _move_x;
				m->wave->add_bar(x, 0, _col);
			}
			old_distance = m->speeder[0]->distance();
		}
	}
}

// EF[u̐FmF
int Stage::col() { return _col; }

int Stage::move_x() { return _move_x; }

int Stage::offset_x() { return _offset_x; }

/**
 * `
 */
void Stage::draw(BOOL ready) {
	if ( _back < 5 ) {
		g->drawImage(m->use_image(DATA_BACK), 0, 0);
		if ( ((m->elapse() / 2) % 2) == 0 ) {
			g->setROP(_ROP_ADD);
			g->setAlpha(63);
			g->drawImage(m->use_image(DATA_BACK), 0, 0);
			g->setAlpha(255);
			g->setROP(_ROP_COPY);
		}
	}

	int distance;
	distance = m->speeder[0]->distance(); if ( distance > DISTANCE ) distance = DISTANCE;
	switch ( _back ) {
	case 0:
		g->drawImage(m->use_image(DATA_FORE1), 20, (240 * distance / DISTANCE) - 240);
		break;
	case 1:
		g->drawImage(m->use_image(DATA_FORE2), (240 * distance / DISTANCE) - 240, 0);
		break;
	case 2:
		g->drawImage(m->use_image(DATA_FORE3), 0 - (160 * distance / DISTANCE), 104);
		break;
	case 3:
		g->drawImage(m->use_image(DATA_FORE4), 320 - (640 * distance / DISTANCE), 0);
		break;
	case 4:
		g->drawImage(m->use_image(DATA_FORE4), 0, (480 * distance / DISTANCE) - 240);
		break;
	case 5:
		g->drawImage(m->use_image(DATA_FORE5A), 0, (1120 * distance / DISTANCE) - 1120      , 0, 0, 640, 800);
		g->drawImage(m->use_image(DATA_FORE5B), 0, (1120 * distance / DISTANCE) - 1120 + 800, 0, 0, 640, 800);
		if ( ((m->elapse() / 2) % 2) == 0 ) {
			g->setROP(_ROP_ADD);
			g->setAlpha(31);
			g->drawImage(m->use_image(DATA_FORE5A), 0, (1120 * distance / DISTANCE) - 1120      , 0, 0, 640, 800);
			g->drawImage(m->use_image(DATA_FORE5B), 0, (1120 * distance / DISTANCE) - 1120 + 800, 0, 0, 640, 800);
			g->setAlpha(255);
			g->setROP(_ROP_COPY);
		}
		break;
	case 6:
		g->drawImage(m->use_image(DATA_FORE6), 0, (420 * distance / DISTANCE) - 420);
		break;
	}

	g->setROP(_ROP_ADD);
	g->setAlpha(192);
	g->lockDraw();
	int h = ready ? 0 : (m->speeder[0]->speed() / 25);
	for ( int i = star->size() - 1; i >= 0; i-- ) {
		Star* tmp = (Star*)star->elementAt(i);
		if ( (tmp->x() >= 0) && (tmp->x() < 640) ) {
			g->drawImage(m->use_image(DATA_STAR), tmp->x(), tmp->y() - 40, h, 0, 1, 40);
		}
	}
	g->unlockDraw();
	g->setAlpha(255);
	g->setROP(_ROP_COPY);
}
