#include <stdio.h>
#include <stdlib.h>
#include <string.h>

char* progName( char* argv0 )
{
	char* szTop;
	char* szTmp;
	szTop = argv0;
	if( (szTmp = strrchr( szTop, '\\' )) != NULL )
	{
		szTop = szTmp + 1;
	}
	if( (szTmp = strrchr( szTop, '.' )) != NULL )
	{
		*szTmp = '\0';
	}
	return strlwr( szTop );
}

char* fgets2( char* buf, int len, FILE* fp )
{
	char* tmp = fgets( buf, len, fp );
	if( tmp != NULL )
	{
		/* s̉sR[h菜 */
		char* szTmp = tmp;
		while( (*szTmp != '\r') && (*szTmp != '\n') && (*szTmp != '\0') )
		{
			szTmp++;
		}
		*szTmp = '\0';
	}
	return tmp;
}

int main( int argc, char* argv[] )
{
	register int i, j;

	FILE* in;
	FILE* in2;
	FILE* out;
	unsigned char* data;
	unsigned long in_size, out_size, tmp_size;

	char szLine[128 + 1];
	char* ptrTop;
	char* ptrEnd;
	char* ptrTmp;

	if( argc < 5 )
	{
		printf( "usage: %s <in_list> <out_file> <out_header> <prefix>\n", progName( argv[0] ) );
		return 0;
	}

	out_size = 0;
	if( (in = fopen( argv[1], "rt" )) == NULL )
	{
		printf( "%s open error.\n", argv[1] );
		return 0;
	}
	else
	{
		data = malloc( 1024 );
		j = 0;
		for( i = 0; ; i++ )
		{
			if( fgets2( szLine, 128, in ) == NULL )
			{
				break;
			}

			if( strlen( szLine ) > 0 )
			{
				if( (in2 = fopen( szLine, "rb" )) == NULL )
				{
					printf( "%s open error.\n", szLine );
					free( data );
					fclose( in );
					return 0;
				}
				tmp_size = 0;
				while( (in_size = fread( data, sizeof(unsigned char), 1024, in2 )) == 1024 )
				{
					tmp_size += in_size;
				}
				tmp_size += in_size;
				fclose( in2 );
				out_size += tmp_size;
				j++;
			}
		}
		out_size += sizeof(unsigned long) * (j + 1);
		free( data );
		fclose( in );
	}

	data = malloc( out_size );

	out_size = sizeof(unsigned long) * (j + 1);
	((unsigned long*)data)[0] = out_size;

	in = fopen( argv[1], "rt" );
	j = 0;
	for( i = 0; ; i++ )
	{
		if( fgets2( szLine, 128, in ) == NULL )
		{
			break;
		}

		if( strlen( szLine ) > 0 )
		{
			printf( "%s", szLine );
			if( (in2 = fopen( szLine, "rb" )) == NULL )
			{
				printf( " open error.\n" );
				free( data );
				fclose( in );
				return 0;
			}
			tmp_size = 0;
			while( (in_size = fread( &data[out_size + tmp_size], sizeof(unsigned char), 1024, in2 )) == 1024 )
			{
				tmp_size += in_size;
			}
			tmp_size += in_size;
			printf( " %d byte(s)\n", tmp_size );
			fclose( in2 );
			out_size += tmp_size;
			((unsigned long*)data)[j + 1] = out_size;
			j++;
		}
	}
	fclose( in );

	printf( "%s", argv[2] );
	if( (out = fopen( argv[2], "w+b" )) != NULL )
	{
		if( fwrite( data, sizeof(char), out_size, out ) == out_size )
		{
			printf( " %d bytes ok.\n", out_size );
		}
		else
		{
			printf( " write error.\n" );
		}
		fclose( out );
	}
	else
	{
		printf( " open error.\n" );
	}

	free( data );

	if( (in = fopen( argv[1], "rt" )) != NULL )
	{
		if( (out = fopen( argv[3], "w+t" )) != NULL )
		{
			i = 0;
			while( fgets2( szLine, 128, in ) != NULL )
			{
				if( strlen( szLine ) > 0 )
				{
					if( (ptrTop = strrchr( szLine, '\\' )) == NULL )
					{
						ptrTop = szLine;
					}
					else
					{
						ptrTop++;
					}
					if( (ptrEnd = strrchr( ptrTop, '.' )) != NULL )
					{
						*ptrEnd = '\0';
					}
					for( ; ; )
					{
						if( (ptrTmp = strchr( ptrTop, '-' )) == NULL )
						{
							break;
						}
						else
						{
							*ptrTmp = '_';
						}
					}
					for( ; ; )
					{
						if( (ptrTmp = strchr( ptrTop, ' ' )) == NULL )
						{
							break;
						}
						else
						{
							*ptrTmp = '_';
						}
					}
					fprintf( out, "#define %s_%s\t%d\n", argv[4], strupr( ptrTop ), i );
					i++;
				}
			}
			fprintf( out, "#define %s_NUM\t%d\n", argv[4], i );
			fclose( out );
		}
		fclose( in );
	}

	return 0;
}
