/* File: mspells3.c */

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */

/* Purpose: Imitation code */

#include "angband.h"

#define pseudo_plev(C) ((((C)->lev + 40) * ((C)->lev + 40) - 1550) / 130)

static void learnedungeon_info(creature_type *creature_ptr, char *p, int power)
{
	int plev = pseudo_plev(creature_ptr);
	int hp = creature_ptr->chp;

#ifdef JP
	cptr s_dam = ":";
	cptr s_dur = ":";
	cptr s_range = "͈:";
	cptr s_heal = ":";
#else
	cptr s_dam = "dam ";
	cptr s_dur = "dur ";
	cptr s_range = "range ";
	cptr s_heal = "heal ";
#endif

	strcpy(p, "");

	switch (power)
	{
		case MS_SHRIEK:
		case MS_XXX1:
		case MS_XXX2:
		case MS_XXX3:
		case MS_XXX4:
		case MS_SCARE:
		case MS_BLIND:
		case MS_CONF:
		case MS_SLOW:
		case MS_SLEEP:
		case MS_HAND_DOOM:
		case MS_WORLD:
		case MS_SPECIAL:
		case MS_TELE_TO:
		case MS_TELE_AWAY:
		case MS_TELE_LEVEL:
		case MS_DARKNESS:
		case MS_MAKE_TRAP:
		case MS_FORGET:
		case MS_S_KIN:
		case MS_S_CYBER:
		case MS_S_MONSTER:
		case MS_S_MONSTERS:
		case MS_S_ANT:
		case MS_S_SPIDER:
		case MS_S_HOUND:
		case MS_S_HYDRA:
		case MS_S_ANGEL:
		case MS_S_DEMON:
		case MS_S_UNDEAD:
		case MS_S_DRAGON:
		case MS_S_HI_UNDEAD:
		case MS_S_HI_DRAGON:
		case MS_S_AMBERITE:
		case MS_S_UNIQUE:
			break;
		case MS_BALL_MANA:
		case MS_BALL_DARK:
		case MS_STARBURST:
			sprintf(p, " %s%d+10d10", s_dam, plev * 8 + 50);
			break;
		case MS_DISPEL:
			break;
		case MS_ROCKET:
			sprintf(p, " %s%d", s_dam, hp/4);
			break;
		case MS_SHOOT:
		{
			object_type *object_ptr = NULL;
			if      (get_equipped_slot_num(creature_ptr, INVEN_SLOT_HAND) > 0) object_ptr = get_equipped_slot_ptr(creature_ptr, INVEN_SLOT_HAND, 1);
			else if (get_equipped_slot_num(creature_ptr, INVEN_SLOT_HAND) > 1) object_ptr = get_equipped_slot_ptr(creature_ptr, INVEN_SLOT_HAND, 2);
			else
				sprintf(p, " %s1", s_dam);
			if (object_ptr)
				sprintf(p, " %s%dd%d+%d", s_dam, object_ptr->dd, object_ptr->ds, object_ptr->to_damage);
			break;
		}
		case MS_BR_ACID:
		case MS_BR_ELEC:
		case MS_BR_FIRE:
		case MS_BR_COLD:
		case MS_BR_POIS:
		case MS_BR_NUKE:
			sprintf(p, " %s%d", s_dam, hp/3);
			break;
		case MS_BR_NEXUS:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 250));
			break;
		case MS_BR_TIME:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 150));
			break;
		case MS_BR_GRAVITY:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 200));
			break;
		case MS_BR_MANA:
			sprintf(p, " %s%d", s_dam, MIN(hp/3, 250));
			break;
		case MS_BR_NETHER:
		case MS_BR_LITE:
		case MS_BR_DARK:
		case MS_BR_CONF:
		case MS_BR_SOUND:
		case MS_BR_CHAOS:
		case MS_BR_DISEN:
		case MS_BR_SHARDS:
		case MS_BR_PLASMA:
			sprintf(p, " %s%d", s_dam, hp/6);
			break;
		case MS_BR_INERTIA:
		case MS_BR_FORCE:
			sprintf(p, " %s%d", s_dam, MIN(hp/6, 200));
			break;
		case MS_BR_DISI:
			sprintf(p, " %s%d", s_dam, MIN(hp/6, 150));
			break;
		case MS_BALL_NUKE:
			sprintf(p, " %s%d+10d6", s_dam, plev * 2);
			break;
		case MS_BALL_CHAOS:
			sprintf(p, " %s%d+10d10", s_dam, plev * 4);
			break;
		case MS_BALL_ACID:
			sprintf(p, " %s15+d%d", s_dam, plev * 6);
			break;
		case MS_BALL_ELEC:
			sprintf(p, " %s8+d%d", s_dam, plev * 3);
			break;
		case MS_BALL_FIRE:
			sprintf(p, " %s10+d%d", s_dam, plev * 7);
			break;
		case MS_BALL_COLD:
			sprintf(p, " %s10+d%d", s_dam, plev * 3);
			break;
		case MS_BALL_POIS:
			sprintf(p, " %s12d2", s_dam);
			break;
		case MS_BALL_NETHER:
			sprintf(p, " %s%d+10d10", s_dam, plev * 2 + 50);
			break;
		case MS_BALL_WATER:
			sprintf(p, " %s50+d%d", s_dam, plev * 4);
			break;
		case MS_DRAIN_MANA:
			sprintf(p, " %sd%d+%d", s_heal, plev, plev);
			break;
		case MS_MIND_BLAST:
			sprintf(p, " %s8d8", s_dam);
			break;
		case MS_BRAIN_SMASH:
			sprintf(p, " %s12d15", s_dam);
			break;
		case MS_CAUSE_1:
			sprintf(p, " %s3d8", s_dam);
			break;
		case MS_CAUSE_2:
			sprintf(p, " %s8d8", s_dam);
			break;
		case MS_CAUSE_3:
			sprintf(p, " %s10d15", s_dam);
			break;
		case MS_CAUSE_4:
			sprintf(p, " %s15d15", s_dam);
			break;
		case MS_BOLT_ACID:
			sprintf(p, " %s%d+7d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_ELEC:
			sprintf(p, " %s%d+4d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_FIRE:
			sprintf(p, " %s%d+9d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_COLD:
			sprintf(p, " %s%d+6d8", s_dam, plev * 2 / 3);
			break;
		case MS_BOLT_NETHER:
			sprintf(p, " %s%d+5d5", s_dam, 30 + plev * 8 / 3);
			break;
		case MS_BOLT_WATER:
			sprintf(p, " %s%d+10d10", s_dam, plev * 2);
			break;
		case MS_BOLT_MANA:
			sprintf(p, " %s50+d%d", s_dam, plev * 7);
			break;
		case MS_BOLT_PLASMA:
			sprintf(p, " %s%d+8d7", s_dam, plev * 2 + 10);
			break;
		case MS_BOLT_ICE:
			sprintf(p, " %s%d+6d6", s_dam, plev * 2);
			break;
		case MS_MAGIC_MISSILE:
			sprintf(p, " %s%d+2d6", s_dam, plev * 2 / 3);
			break;
		case MS_SPEED:
			sprintf(p, " %sd%d+%d", s_dur, 20+plev, plev);
			break;
		case MS_HEAL:
			sprintf(p, " %s%d", s_heal, plev*4);
			break;
		case MS_INVULNER:
			sprintf(p, " %sd7+7", s_dur);
			break;
		case MS_BLINK:
			sprintf(p, " %s10", s_range);
			break;
		case MS_TELEPORT:
			sprintf(p, " %s%d", s_range, plev * 5);
			break;
		case MS_PSY_SPEAR:
			sprintf(p, " %s100+d%d", s_dam, plev * 3);
			break;
		case MS_RAISE_DEAD:
			sprintf(p, " %s5", s_range);
			break;
		default:
			break;
	}
}


/*
 * Allow user to choose a imitation.
 *
 * If a valid spell is chosen, saves it in '*sn' and returns TRUE
 * If the user hits escape, returns FALSE, and set '*sn' to -1
 * If there are no legal choices, returns FALSE, and sets '*sn' to -2
 *
 * The "prompt" should be "cast", "recite", or "study"
 * The "known" should be TRUE for cast/pray, FALSE for study
 *
 * nb: This function has a (trivial) display bug which will be obvious
 * when you run it. It's probably easy to fix but I haven't tried,
 * sorry.
 */
static int get_learned_power(creature_type *creature_ptr, int *sn)
{
	int             i = 0;
	int             num = 0;
	int             y = 1;
	int             x = 18;
	int             minfail = 0;
	int             plev = creature_ptr->lev;
	int             chance = 0;
	int             ask = TRUE, mode = 0;
	int             spellnum[MAX_MONSPELLS];
	char            ch;
	char            choice;
	char            out_val[160];
	char            comment[80];
	s32b            f4 = 0, f5 = 0, f6 = 0;
#ifdef JP
cptr            p = "@";
#else
	cptr            p = "magic";
#endif

	racial_power   spell;
	bool            flag, redraw;
	int menu_line = (use_menu ? 1 : 0);

	/* Assume cancelled */
	*sn = (-1);

	/* Nothing chosen yet */
	flag = FALSE;

	/* No redraw yet */
	redraw = FALSE;

	/* Get the spell, if available */
	if (repeat_pull(sn))
	{
		/* Success */
		return (TRUE);
	}

	if (use_menu)
	{
		screen_save();

		while(!mode)
		{
#ifdef JP
			prt(format(" %s {g", (menu_line == 1) ? "t" : "  "), 2, 14);
			prt(format(" %s {[", (menu_line == 2) ? "t" : "  "), 3, 14);
			prt(format(" %s uX", (menu_line == 3) ? "t" : "  "), 4, 14);
			prt(format(" %s ", (menu_line == 4) ? "t" : "  "), 5, 14);
			prt(format(" %s ̑", (menu_line == 5) ? "t" : "  "), 6, 14);
			prt("ǂ̎ނ̖@g܂H", 0, 0);
#else
			prt(format(" %s bolt", (menu_line == 1) ? "> " : "  "), 2, 14);
			prt(format(" %s ball", (menu_line == 2) ? "> " : "  "), 3, 14);
			prt(format(" %s breath", (menu_line == 3) ? "> " : "  "), 4, 14);
			prt(format(" %s sommoning", (menu_line == 4) ? "> " : "  "), 5, 14);
			prt(format(" %s others", (menu_line == 5) ? "> " : "  "), 6, 14);
			prt("use which type of magic? ", 0, 0);
#endif
			choice = inkey();
			switch(choice)
			{
			case ESCAPE:
			case 'z':
			case 'Z':
				screen_load();
				return FALSE;
			case '2':
			case 'j':
			case 'J':
				menu_line++;
				break;
			case '8':
			case 'k':
			case 'K':
				menu_line+= 4;
				break;
			case '\r':
			case 'x':
			case 'X':
				mode = menu_line;
				break;
			}
			if (menu_line > 5) menu_line -= 5;
		}
		screen_load();
	}
	else
	{
#ifdef JP
	sprintf(comment, "[A]{g, [B]{[, [C]uX, [D], [E]̑:");
#else
	sprintf(comment, "[A] bolt, [B] ball, [C] breath, [D] summoning, [E] others:");
#endif
	while (TRUE)
	{
		if (!get_com(comment, &ch, TRUE))
		{
			return FALSE;
		}
		if (ch == 'A' || ch == 'a')
		{
			mode = 1;
			break;
		}
		if (ch == 'B' || ch == 'b')
		{
			mode = 2;
			break;
		}
		if (ch == 'C' || ch == 'c')
		{
			mode = 3;
			break;
		}
		if (ch == 'D' || ch == 'd')
		{
			mode = 4;
			break;
		}
		if (ch == 'E' || ch == 'e')
		{
			mode = 5;
			break;
		}
	}
	}

	//TODO set_rf_masks(&f4, &f5, &f6, mode);

	for (i = 0, num = 0; i < 32; i++)
	{
		if ((0x00000001 << i) & f4) spellnum[num++] = i;
	}
	for (; i < 64; i++)
	{
		if ((0x00000001 << (i - 32)) & f5) spellnum[num++] = i;
	}
	for (; i < 96; i++)
	{
		if ((0x00000001 << (i - 64)) & f6) spellnum[num++] = i;
	}
	for (i = 0; i < num; i++)
	{
		if (creature_ptr->magic_num2[spellnum[i]])
		{
			if (use_menu) menu_line = i+1;
			break;
		}
	}
	if (i == num)
	{
#ifdef JP
		msg_print("̎ނ̖@͊oĂȂI");
#else
		msg_print("You don't know any spell of this type.");
#endif
		return (FALSE);
	}

	/* Build a prompt (accept all spells) */
	(void)strnfmt(out_val, 78, 
#ifdef JP
		      "(%c-%c, '*'ňꗗ, ESC) ǂ%s܂H",
#else
		      "(%c-%c, *=List, ESC=exit) Use which %s? ",
#endif
		      I2A(0), I2A(num - 1), p);

	if (use_menu) screen_save();

	/* Get a spell from the user */

	choice= (always_show_list || use_menu) ? ESCAPE:1 ;
	while (!flag)
	{
		if(choice==ESCAPE) choice = ' '; 
		else if( !get_com(out_val, &choice, TRUE) )break; 

		if (use_menu && choice != ' ')
		{
			switch(choice)
			{
				case '0':
				{
					screen_load();
					return (FALSE);
				}

				case '8':
				case 'k':
				case 'K':
				{
					do
					{
						menu_line += (num-1);
						if (menu_line > num) menu_line -= num;
					} while(!creature_ptr->magic_num2[spellnum[menu_line-1]]);
					break;
				}

				case '2':
				case 'j':
				case 'J':
				{
					do
					{
						menu_line++;
						if (menu_line > num) menu_line -= num;
					} while(!creature_ptr->magic_num2[spellnum[menu_line-1]]);
					break;
				}

				case '6':
				case 'l':
				case 'L':
				{
					menu_line=num;
					while(!creature_ptr->magic_num2[spellnum[menu_line-1]]) menu_line--;
					break;
				}

				case '4':
				case 'h':
				case 'H':
				{
					menu_line=1;
					while(!creature_ptr->magic_num2[spellnum[menu_line-1]]) menu_line++;
					break;
				}

				case 'x':
				case 'X':
				case '\r':
				{
					i = menu_line - 1;
					ask = FALSE;
					break;
				}
			}
		}
		/* Request redraw */
		if ((choice == ' ') || (choice == '*') || (choice == '?') || (use_menu && ask))
		{
			/* Show the list */
			if (!redraw || use_menu)
			{
				char psi_desc[80];

				/* Show list */
				redraw = TRUE;

				/* Save the screen */
				if (!use_menu) screen_save();

				/* Display a list of spells */
				prt("", y, x);
#ifdef JP
put_str("O", y, x + 5);
#else
				put_str("Name", y, x + 5);
#endif

#ifdef JP
put_str("MP  ", y, x + 33);
#else
				put_str("SP Fail Info", y, x + 32);
#endif


				/* Dump the spells */
				for (i = 0; i < num; i++)
				{
					int need_mana;

					prt("", y + i + 1, x);
					if (!creature_ptr->magic_num2[spellnum[i]]) continue;

					/* Access the spell */
					spell = racial_powers[spellnum[i]];

					chance = spell.fail;

					/* Reduce failure rate by "effective" level adjustment */
					if (plev > spell.level) chance -= 3 * (plev - spell.level);
					else chance += (spell.level - plev);

					/* Reduce failure rate by INT/WIS adjustment */
					chance -= 3 * (adj_mag_stat[creature_ptr->stat_ind[STAT_INT]] - 1);

					chance = mod_spell_chance_1(creature_ptr, chance);

					need_mana = mod_need_mana(creature_ptr, racial_powers[spellnum[i]].smana, 0, REALM_NONE);

					/* Not enough mana to cast */
					if (need_mana > creature_ptr->csp)
					{
						chance += 5 * (need_mana - creature_ptr->csp);
					}

					/* Extract the minimum failure rate */
					minfail = adj_mag_fail[creature_ptr->stat_ind[STAT_INT]];

					/* Minimum failure rate */
					if (chance < minfail) chance = minfail;

					/* Stunning makes spells harder */
					if (creature_ptr->stun > 50) chance += 25;
					else if (creature_ptr->stun) chance += 15;

					/* Always a 5 percent chance of working */
					if (chance > 95) chance = 95;

					chance = mod_spell_chance_2(creature_ptr, chance);

					/* Get info */
					learnedungeon_info(creature_ptr, comment, spellnum[i]);

					if (use_menu)
					{
#ifdef JP
						if (i == (menu_line-1)) strcpy(psi_desc, "  t");
#else
						if (i == (menu_line-1)) strcpy(psi_desc, "  > ");
#endif
						else strcpy(psi_desc, "    ");
					}
					else sprintf(psi_desc, "  %c)", I2A(i));

					/* Dump the spell --(-- */
					strcat(psi_desc, format(" %-26s %3d %3d%%%s",
						spell.name, need_mana,
						chance, comment));
					prt(psi_desc, y + i + 1, x);
				}

				/* Clear the bottom line */
				if (y < 22) prt("", y + i + 1, x);
			}

			/* Hide the list */
			else
			{
				/* Hide list */
				redraw = FALSE;

				/* Restore the screen */
				screen_load();
			}

			/* Redo asking */
			continue;
		}

		if (!use_menu)
		{
			/* Note verify */
			ask = isupper(choice);

			/* Lowercase */
			if (ask) choice = tolower(choice);

			/* Extract request */
			i = (islower(choice) ? A2I(choice) : -1);
		}

		/* Totally Illegal */
		if ((i < 0) || (i >= num) || !creature_ptr->magic_num2[spellnum[i]])
		{
			bell();
			continue;
		}

		/* Save the spell index */
		spell = racial_powers[spellnum[i]];

		/* Verify it */
		if (ask)
		{
			char tmp_val[160];

			/* Prompt */
#ifdef JP
			(void) strnfmt(tmp_val, 78, "%s̖@܂H", racial_powers[spellnum[i]].name);
#else
			(void)strnfmt(tmp_val, 78, "Use %s? ", racial_powers[spellnum[i]].name);
#endif


			/* Belay that order */
			if (!get_check(tmp_val)) continue;
		}

		/* Stop the loop */
		flag = TRUE;
	}

	/* Restore the screen */
	if (redraw) screen_load();

	/* Show choices */
	play_window |= (PW_SPELL);

	/* Window stuff */
	window_stuff();

	/* Abort if needed */
	if (!flag) return (FALSE);

	/* Save the choice */
	(*sn) = spellnum[i];

	repeat_push(*sn);

	/* Success */
	return (TRUE);
}



// do_cmd_cast calls this function if the player's class
// is 'imitator'.
static bool cast_learned_spell(creature_type *caster_ptr, int spell, bool success)
{
	floor_type *floor_ptr = get_floor_ptr(caster_ptr);
	int            dir;
	int           plev = pseudo_plev(caster_ptr);
	int     summon_lev = caster_ptr->lev * 2 / 3 + randint1(caster_ptr->lev/2);
	int             hp = caster_ptr->chp;
	int             damage = 0;
	bool   pet = success;
	bool   no_trump = FALSE;
	u32b p_mode, u_mode = 0L, g_mode;

	if (pet)
	{
		p_mode = PM_FORCE_PET;
		g_mode = 0;
	}
	else
	{
		p_mode = PM_NO_PET;
		g_mode = PM_ALLOW_GROUP;
	}

	if (!success || (randint1(50+plev) < plev/10)) u_mode = PM_ALLOW_UNIQUE;

	/* spell code */
	switch (spell)
	{
	case MS_SHRIEK:
#ifdef JP
msg_print("񍂂؂萺B");
#else
		msg_print("You make a high pitched shriek.");
#endif

		aggravate_creatures(caster_ptr);
		break;
	case MS_XXX1:
		break;
	case MS_DISPEL:
	{
		int m_idx;

		if (!target_set(caster_ptr, TARGET_KILL)) return FALSE;
		m_idx = floor_ptr->cave[target_row][target_col].creature_idx;
		if (!m_idx) break;
		if (!player_has_los_bold(target_row, target_col)) break;
		if (!projectable(floor_ptr, caster_ptr->fy, caster_ptr->fx, target_row, target_col)) break;
		dispel_creature(&creature_list[m_idx]);
		break;
	}
	case MS_ROCKET:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		else
#ifdef JP
msg_print("Pbg𔭎˂B");
#else
			msg_print("You fire a rocket.");
#endif
		damage = hp / 4;
			fire_rocket(caster_ptr, GF_ROCKET, dir, damage, 2);
		break;
	case MS_SHOOT:
	{
		object_type *object_ptr = NULL;

		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		else
		{
#ifdef JP
msg_print("B");
#else
			msg_print("You fire an arrow.");
#endif
			if (get_equipped_slot_num(caster_ptr, INVEN_SLOT_HAND) > 0) object_ptr = get_equipped_slot_ptr(caster_ptr, INVEN_SLOT_HAND, 1);
			else if (get_equipped_slot_num(caster_ptr, INVEN_SLOT_HAND) > 1) object_ptr = get_equipped_slot_ptr(caster_ptr, INVEN_SLOT_HAND, 2);
			else
			damage = 1;
			if (object_ptr)
			{
				damage = diceroll(object_ptr->dd, object_ptr->ds)+ object_ptr->to_damage;
				if (damage < 1) damage = 1;
			}
			fire_bolt(caster_ptr, GF_ARROW, dir, damage);
		}
		break;
	}
	case MS_XXX2:
		break;
	case MS_XXX3:
		break;
	case MS_XXX4:
		break;
	case MS_BR_ACID:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("_̃uXfB");
#else
			else msg_print("You breathe acid.");
#endif
		damage = hp / 3;
		fire_ball(caster_ptr, GF_ACID, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_ELEC:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("Ȃ̃uXfB");
#else
			else msg_print("You breathe lightning.");
#endif
		damage = hp / 3;
		fire_ball(caster_ptr, GF_ELEC, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_FIRE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("Ή̃uXfB");
#else
			else msg_print("You breathe fire.");
#endif
		damage = hp / 3;
		fire_ball(caster_ptr, GF_FIRE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_COLD:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("C̃uXfB");
#else
			else msg_print("You breathe frost.");
#endif
		damage = hp / 3;
		fire_ball(caster_ptr, GF_COLD, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_POIS:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("KX̃uXfB");
#else
			else msg_print("You breathe gas.");
#endif
		damage = hp / 3;
		fire_ball(caster_ptr, GF_POIS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_NETHER:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("ñuXfB");
#else
			else msg_print("You breathe nether.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_NETHER, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_LITE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("M̃uXfB");
#else
			else msg_print("You breathe light.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_LITE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_DARK:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("Í̃uXfB");
#else
			else msg_print("You breathe darkness.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_DARK, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_CONF:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("̃uXfB");
#else
			else msg_print("You breathe confusion.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_CONFUSION, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_SOUND:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("̃uXfB");
#else
			else msg_print("You breathe sound.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_SOUND, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_CHAOS:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("JIX̃uXfB");
#else
			else msg_print("You breathe chaos.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_CHAOS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_DISEN:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("򉻂̃uXfB");
#else
			else msg_print("You breathe disenchantment.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_DISENCHANT, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_NEXUS:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("ʍ̃uXfB");
#else
			else msg_print("You breathe nexus.");
#endif
		damage = MIN(hp / 3, 250);
		fire_ball(caster_ptr, GF_NEXUS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_TIME:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("ԋt]̃uXfB");
#else
			else msg_print("You breathe time.");
#endif
		damage = MIN(hp / 3, 150);
		fire_ball(caster_ptr, GF_TIME, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_INERTIA:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("x݂̃uXfB");
#else
			else msg_print("You breathe inertia.");
#endif
		damage = MIN(hp / 6, 200);
		fire_ball(caster_ptr, GF_INERTIA, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_GRAVITY:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("d͂̃uXfB");
#else
			else msg_print("You breathe gravity.");
#endif
		damage = MIN(hp / 3, 200);
		fire_ball(caster_ptr, GF_GRAVITY, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_SHARDS:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("jЂ̃uXfB");
#else
			else msg_print("You breathe shards.");
#endif
		damage = hp / 6;
		fire_ball(caster_ptr, GF_SHARDS, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_PLASMA:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("vY}̃uXfB");
#else
			else msg_print("You breathe plasma.");
#endif
		damage = MIN(hp / 6, 150);
		fire_ball(caster_ptr, GF_PLASMA, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_FORCE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("tH[X̃uXfB");
#else
			else msg_print("You breathe force.");
#endif
		damage = MIN(hp / 6, 200);
		fire_ball(caster_ptr, GF_FORCE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BR_MANA:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("͂̃uXfB");
#else
			else msg_print("You breathe mana.");
#endif
		
		damage = MIN(hp / 3, 250);
		fire_ball(caster_ptr, GF_MANA, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BALL_NUKE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("˔\B");
#else
			else msg_print("You cast a ball of radiation.");
#endif
		damage = plev * 2 + diceroll(10, 6);
		fire_ball(caster_ptr, GF_NUKE, dir, damage, 2);
		break;
	case MS_BR_NUKE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("ːp̃uXfB");
#else
			else msg_print("You breathe toxic waste.");
#endif
		damage = hp / 3;
		fire_ball(caster_ptr, GF_NUKE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BALL_CHAOS:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("OXB");
#else
			else msg_print("You invoke a raw Logrus.");
#endif
		damage = plev * 4 + diceroll(10, 10);
		fire_ball(caster_ptr, GF_CHAOS, dir, damage, 4);
		break;
	case MS_BR_DISI:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("̃uXfB");
#else
			else msg_print("You breathe disintegration.");
#endif
		damage = MIN(hp / 6, 150);
		fire_ball(caster_ptr, GF_DISINTEGRATE, dir, damage, (plev > 40 ? -3 : -2));
		break;
	case MS_BALL_ACID:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("AVbhE{[̎B");
#else
			else msg_print("You cast an acid ball.");
#endif
		damage = randint1(plev * 6) + 15;
		fire_ball(caster_ptr, GF_ACID, dir, damage, 2);
		break;
	case MS_BALL_ELEC:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("T_[E{[̎B");
#else
			else msg_print("You cast a lightning ball.");
#endif
		damage = randint1(plev * 3) + 8;
		fire_ball(caster_ptr, GF_ELEC, dir, damage, 2);
		break;
	case MS_BALL_FIRE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("t@CAE{[̎B");
#else
			else msg_print("You cast a fire ball.");
#endif
		damage = randint1(plev * 7) + 10;
		fire_ball(caster_ptr, GF_FIRE, dir, damage, 2);
		break;
	case MS_BALL_COLD:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("ACXE{[̎B");
#else
			else msg_print("You cast a frost ball.");
#endif
		damage = randint1(plev * 3) + 10;
		fire_ball(caster_ptr, GF_COLD, dir, damage, 2);
		break;
	case MS_BALL_POIS:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("L_̎B");
#else
			else msg_print("You cast a stinking cloud.");
#endif
		damage = diceroll(12,2);
		fire_ball(caster_ptr, GF_POIS, dir, damage, 2);
		break;
	case MS_BALL_NETHER:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("n̎B");
#else
			else msg_print("You cast a nether ball.");
#endif
		damage = plev * 2 + 50 + diceroll(10, 10);
		fire_ball(caster_ptr, GF_NETHER, dir, damage, 2);
		break;
	case MS_BALL_WATER:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("悤ȐgUB");
#else
			else msg_print("You gesture fluidly.");
#endif
		damage = randint1(plev * 4) + 50;
		fire_ball(caster_ptr, GF_WATER, dir, damage, 4);
		break;
	case MS_BALL_MANA:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("̗͂̎OB");
#else
			else msg_print("You invoke a mana storm.");
#endif
		damage = plev * 8 + 50 + diceroll(10, 10);
		fire_ball(caster_ptr, GF_MANA, dir, damage, 4);
		break;
	case MS_BALL_DARK:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("Í̗̎OB");
#else
			else msg_print("You invoke a darkness storm.");
#endif
		damage = plev * 8 + 50 + diceroll(10, 10);
		fire_ball(caster_ptr, GF_DARK, dir, damage, 4);
		break;
	case MS_DRAIN_MANA:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		fire_ball_hide(caster_ptr, GF_DRAIN_MANA, dir, randint1(plev)+plev, 0);
		break;
	case MS_MIND_BLAST:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		damage = diceroll(7, 7);
		fire_ball_hide(caster_ptr, GF_MIND_BLAST, dir, damage, 0);
		break;
	case MS_BRAIN_SMASH:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		damage = diceroll(12, 12);
		fire_ball_hide(caster_ptr, GF_BRAIN_SMASH, dir, damage, 0);
		break;
	case MS_CAUSE_1:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		damage = diceroll(3, 8);
		fire_ball_hide(caster_ptr, GF_CAUSE_1, dir, damage, 0);
		break;
	case MS_CAUSE_2:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		damage = diceroll(8, 8);
		fire_ball_hide(caster_ptr, GF_CAUSE_2, dir, damage, 0);
		break;
	case MS_CAUSE_3:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		damage = diceroll(10, 15);
		fire_ball_hide(caster_ptr, GF_CAUSE_3, dir, damage, 0);
		break;
	case MS_CAUSE_4:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		damage = diceroll(15, 15);
		fire_ball_hide(caster_ptr, GF_CAUSE_4, dir, damage, 0);
		break;
	case MS_BOLT_ACID:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("AVbhE{g̎B");
#else
			else msg_print("You cast an acid bolt.");
#endif
		damage = diceroll(7, 8) + plev * 2 / 3;
		fire_bolt(caster_ptr, GF_ACID, dir, damage);
		break;
	case MS_BOLT_ELEC:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("T_[E{g̎B");
#else
			else msg_print("You cast a lightning bolt.");
#endif
		damage = diceroll(4, 8) + plev * 2 / 3;
		fire_bolt(caster_ptr, GF_ELEC, dir, damage);
		break;
	case MS_BOLT_FIRE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("t@CAE{g̎B");
#else
			else msg_print("You cast a fire bolt.");
#endif
		damage = diceroll(9, 8) + plev * 2 / 3;
		fire_bolt(caster_ptr, GF_FIRE, dir, damage);
		break;
	case MS_BOLT_COLD:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("ACXE{g̎B");
#else
			else msg_print("You cast a frost bolt.");
#endif
		damage = diceroll(6, 8) + plev * 2 / 3;
		fire_bolt(caster_ptr, GF_COLD, dir, damage);
		break;
	case MS_STARBURST:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		else
#ifdef JP
msg_print("X^[o[Xg̎OB");
#else
			msg_print("You invoke a starburst.");
#endif
		damage = plev * 8 + 50 + diceroll(10, 10);
		fire_ball(caster_ptr, GF_LITE, dir, damage, 4);
		break;
	case MS_BOLT_NETHER:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("n̖̎B");
#else
			else msg_print("You cast a nether bolt.");
#endif
		damage = 30 + diceroll(5, 5) + plev * 8 / 3;
		fire_bolt(caster_ptr, GF_NETHER, dir, damage);
		break;
	case MS_BOLT_WATER:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("EH[^[E{g̎B");
#else
			else msg_print("You cast a water bolt.");
#endif
		damage = diceroll(10, 10) + plev * 2;
		fire_bolt(caster_ptr, GF_WATER, dir, damage);
		break;
	case MS_BOLT_MANA:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("̖͂̎B");
#else
			else msg_print("You cast a mana bolt.");
#endif
		damage = randint1(plev * 7) + 50;
		fire_bolt(caster_ptr, GF_MANA, dir, damage);
		break;
	case MS_BOLT_PLASMA:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("vY}E{g̎B");
#else
			else msg_print("You cast a plasma bolt.");
#endif
		damage = 10 + diceroll(8, 7) + plev * 2;
		fire_bolt(caster_ptr, GF_PLASMA, dir, damage);
		break;
	case MS_BOLT_ICE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("Ɋ̖̎B");
#else
			else msg_print("You cast a ice bolt.");
#endif
		damage = diceroll(6, 6) + plev * 2;
		fire_bolt(caster_ptr, GF_ICE, dir, damage);
		break;
	case MS_MAGIC_MISSILE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("}WbNE~TC̎B");
#else
			else msg_print("You cast a magic missile.");
#endif
		damage = diceroll(2, 6) + plev * 2 / 3;
		fire_bolt(caster_ptr, GF_MISSILE, dir, damage);
		break;
	case MS_SCARE:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("낵ȌooB");
#else
			else msg_print("You cast a fearful illusion.");
#endif
		fear_creature(caster_ptr, dir, plev+10);
		break;
	case MS_BLIND:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		confuse_creature(caster_ptr, dir, plev * 2);
		break;
	case MS_CONF:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("UfIȌooB");
#else
			else msg_print("You cast a mesmerizing illusion.");
#endif
		confuse_creature(caster_ptr, dir, plev * 2);
		break;
	case MS_SLOW:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		slow_creature(caster_ptr, dir);
		break;
	case MS_SLEEP:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
		sleep_creature(caster_ptr, dir);
		break;
	case MS_SPEED:
		(void)set_fast(caster_ptr, randint1(20 + plev) + plev, FALSE);
		break;
	case MS_HAND_DOOM:
	{
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;
#ifdef JP
else msg_print("<jł̎>I");
#else
		else msg_print("You invoke the Hand of Doom!");
#endif

		fire_ball_hide(caster_ptr, GF_HAND_DOOM, dir, plev * 3, 0);
		break;
	}
	case MS_HEAL:
#ifdef JP
msg_print("̏ɔOWB");
#else
			msg_print("You concentrate on your wounds!");
#endif
		(void)hp_player(caster_ptr, plev*4);
		(void)set_stun(caster_ptr, 0);
		(void)set_cut(caster_ptr, 0);
		break;
	case MS_INVULNER:
#ifdef JP
msg_print("̋̎B");
#else
			msg_print("You cast a Globe of Invulnerability.");
#endif
		(void)set_invuln(caster_ptr, randint1(4) + 4, FALSE);
		break;
	case MS_BLINK:
		teleport_player(caster_ptr, 10, 0L);
		break;
	case MS_TELEPORT:
		teleport_player(caster_ptr, plev * 5, 0L);
		break;
	case MS_WORLD:
		caster_ptr->time_stopper = TRUE;
#ifdef JP
		msg_print("uIv");
#else
		msg_print("'Time!'");
#endif
		msg_print(NULL);

		/* Hack */
		caster_ptr->energy_need -= 1000 + (100 + (s16b)randint1(200)+200)*TURNS_PER_TICK/10;

		/* Redraw map */
		play_redraw |= (PR_MAP);

		// Update creatures
		update |= (PU_MONSTERS);

		/* Window stuff */
		play_window |= (PW_OVERHEAD | PW_DUNGEON);

		handle_stuff();
		break;
	case MS_SPECIAL:
		break;
	case MS_TELE_TO:
	{
		creature_type *m_ptr;
		species_type *r_ptr;
		char m_name[80];

		if (!target_set(caster_ptr, TARGET_KILL)) return FALSE;
		if (!floor_ptr->cave[target_row][target_col].creature_idx) break;
		if (!player_has_los_bold(target_row, target_col)) break;
		if (!projectable(floor_ptr, caster_ptr->fy, caster_ptr->fx, target_row, target_col)) break;
		m_ptr = &creature_list[floor_ptr->cave[target_row][target_col].creature_idx];
		r_ptr = &species_info[m_ptr->species_idx];
		creature_desc(m_name, m_ptr, 0);
		if (has_trait(m_ptr, TRAIT_RES_TELE))
		{
			if ((is_unique_creature(m_ptr)) || has_trait(m_ptr, TRAIT_RES_ALL))
			{
				if (is_original_ap_and_seen(player_ptr, m_ptr)) reveal_creature_info(m_ptr, TRAIT_RES_TELE);
#ifdef JP
				msg_format("%sɂ͌ʂȂI", m_name);
#else
				msg_format("%s is unaffected!", m_name);
#endif

				break;
			}
			else if (r_ptr->level > randint1(100))
			{
				if (is_original_ap_and_seen(player_ptr, m_ptr)) reveal_creature_info(m_ptr, TRAIT_RES_TELE);
#ifdef JP
				msg_format("%sɂ͑ϐI", m_name);
#else
				msg_format("%s resists!", m_name);
#endif

				break;
			}
		}
#ifdef JP
msg_format("%s߂B", m_name);
#else
		msg_format("You command %s to return.", m_name);
#endif

		teleport_creature_to2(floor_ptr->cave[target_row][target_col].creature_idx, caster_ptr, caster_ptr->fy, caster_ptr->fx, 100, TELEPORT_PASSIVE);
		break;
	}
	case MS_TELE_AWAY:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;

		(void)fire_beam(caster_ptr, GF_AWAY_ALL, dir, 100);
		break;
	case MS_TELE_LEVEL:
	{
		int target_m_idx;
		creature_type *m_ptr;
		species_type *r_ptr;
		char m_name[80];

		if (!target_set(caster_ptr, TARGET_KILL)) return FALSE;
		target_m_idx = floor_ptr->cave[target_row][target_col].creature_idx;
		if (!target_m_idx) break;
		if (!player_has_los_bold(target_row, target_col)) break;
		if (!projectable(floor_ptr, caster_ptr->fy, caster_ptr->fx, target_row, target_col)) break;
		m_ptr = &creature_list[target_m_idx];
		r_ptr = &species_info[m_ptr->species_idx];
		creature_desc(m_name, m_ptr, 0);
#ifdef JP
		msg_format("%^s̑wB", m_name);
#else
		msg_format("You gesture at %^s's feet.", m_name);
#endif

		if (has_trait(m_ptr, TRAIT_RES_NEXU) || has_trait(m_ptr, TRAIT_RES_TELE) ||
			is_quest_species(r_ptr) || (r_ptr->level + randint1(50) > plev + randint1(60)))
		{
#ifdef JP
			msg_print("ʂȂI");
#else
			msg_format("%^s is unaffected!", m_name);
#endif
		}
		else teleport_level(caster_ptr, target_m_idx);
		break;
	}
	case MS_PSY_SPEAR:
		if (!get_aim_dir(caster_ptr, &dir)) return FALSE;

#ifdef JP
else msg_print("̌B");
#else
			else msg_print("You throw a psycho-spear.");
#endif
		damage = randint1(plev * 3) + 100;
		(void)fire_beam(caster_ptr, GF_PSY_SPEAR, dir, damage);
		break;
	case MS_DARKNESS:
#ifdef JP
msg_print("Èł̒ŎUB");
#else
			msg_print("You gesture in shadow.");
#endif
		(void)unlite_area(caster_ptr, 10, 3);
		break;
	case MS_MAKE_TRAP:
		if (!target_set(caster_ptr, TARGET_KILL)) return FALSE;
#ifdef JP
msg_print("Ď׈ɔ΂񂾁B");
#else
			msg_print("You cast a spell and cackle evilly.");
#endif
		trap_creation(caster_ptr, target_row, target_col);
		break;
	case MS_FORGET:
#ifdef JP
msg_print("NȂB");
#else
			msg_print("Nothing happen.");
#endif
		break;
	case MS_RAISE_DEAD:
#ifdef JP
msg_print("ҕ̎B");
#else
		msg_print("You cast a animate dead.");
#endif
		(void)animate_dead(NULL, caster_ptr->fy, caster_ptr->fx);
		break;
	case MS_S_KIN:
	{
		int k;
#ifdef JP
msg_print("RB");
#else
			msg_print("You summon minions.");
#endif
		for (k = 0;k < 1; k++)
		{
			if (summon_kin_player(caster_ptr, summon_lev, caster_ptr->fy, caster_ptr->fx, (pet ? PM_FORCE_PET : 0L)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽԂ͓{ĂI");
#else
msg_print("Summoned fellows are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		}
		break;
	}
	case MS_S_CYBER:
	{
		int k;
#ifdef JP
msg_print("TCo[f[I");
#else
			msg_print("You summon a Cyberdemon!");
#endif
		for (k = 0 ;k < 1 ; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_CYBER, p_mode))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽTCo[f[͓{ĂI");
#else
msg_print("The summoned Cyberdemon are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_MONSTER:
	{
		int k;
#ifdef JP
msg_print("ԂB");
#else
			msg_print("You summon help.");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, 0, p_mode))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽN[`[͓{ĂI");
#else
msg_print("The summoned creature is angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_MONSTERS:
	{
		int k;
#ifdef JP
msg_print("N[`[I");
#else
			msg_print("You summon creatures!");
#endif
		for (k = 0;k < plev / 15 + 2; k++)
			if(summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, 0, (p_mode | u_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽN[`[͓{ĂI");
#else
msg_print("Summoned creatures are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_ANT:
	{
		int k;
#ifdef JP
msg_print("AB");
#else
			msg_print("You summon ants.");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_ANT, (PM_ALLOW_GROUP | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽA͓{ĂI");
#else
msg_print("Summoned ants are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_SPIDER:
	{
		int k;
#ifdef JP
msg_print("w偂B");
#else
			msg_print("You summon spiders.");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_SPIDER, (PM_ALLOW_GROUP | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽw偂͓{ĂI");
#else
msg_print("Summoned spiders are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HOUND:
	{
		int k;
#ifdef JP
msg_print("nEhB");
#else
			msg_print("You summon hounds.");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_HOUND, (PM_ALLOW_GROUP | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽnEh͓{ĂI");
#else
msg_print("Summoned hounds are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HYDRA:
	{
		int k;
#ifdef JP
msg_print("qhB");
#else
			msg_print("You summon a hydras.");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_HYDRA, (g_mode | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽqh͓{ĂI");
#else
msg_print("Summoned hydras are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_ANGEL:
	{
		int k;
#ifdef JP
msg_print("VgI");
#else
			msg_print("You summon an angel!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_ANGEL, (g_mode | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽVg͓{ĂI");
#else
msg_print("Summoned angels are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_DEMON:
	{
		int k;
#ifdef JP
msg_print("ׂ̋{삩爫I");
#else
			msg_print("You summon a demon from the Courts of Chaos!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_DEMON, (g_mode | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽf[͓{ĂI");
#else
msg_print("Summoned demons are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_UNDEAD:
	{
		int k;
#ifdef JP
msg_print("Afbh̋GI");
#else
			msg_print("You summon an undead adversary!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_UNDEAD, (g_mode | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽAfbh͓{ĂI");
#else
msg_print("Summoned undeads are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_DRAGON:
	{
		int k;
#ifdef JP
msg_print("hSI");
#else
			msg_print("You summon a dragon!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_DRAGON, (g_mode | p_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽhS͓{ĂI");
#else
msg_print("Summoned dragons are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HI_UNDEAD:
	{
		int k;
#ifdef JP
msg_print("͂ȃAfbhI");
#else
			msg_print("You summon a greater undead!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_HI_UNDEAD, (g_mode | p_mode | u_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽ㋉Afbh͓{ĂI");
#else
msg_print("Summoned greater undeads are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_HI_DRAGON:
	{
		int k;
#ifdef JP
msg_print("ÑhSI");
#else
			msg_print("You summon an ancient dragon!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_HI_DRAGON, (g_mode | p_mode | u_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽÑhS͓{ĂI");
#else
msg_print("Summoned ancient dragons are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_AMBERITE:
	{
		int k;
#ifdef JP
msg_print("Ao[̉I");
#else
			msg_print("You summon a Lord of Amber!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_AMBERITES, (g_mode | p_mode | u_mode)))
			{
				if (!pet)
#ifdef JP
msg_print("ꂽAo[͓̉{ĂI");
#else
msg_print("Summoned Lords of Amber are angry!");
#endif
			}
			else
			{
				no_trump = TRUE;
			}
		break;
	}
	case MS_S_UNIQUE:
	{
		int k, count = 0;
#ifdef JP
msg_print("ʂȋGI");
#else
			msg_print("You summon a special opponent!");
#endif
		for (k = 0;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_UNIQUE, (g_mode | p_mode | PM_ALLOW_UNIQUE)))
			{
				count++;
				if (!pet)
#ifdef JP
msg_print("ꂽj[NEN[`[͓{ĂI");
#else
msg_print("Summoned special opponents are angry!");
#endif
			}
		for (k = count;k < 1; k++)
			if (summon_specific((pet ? caster_ptr : NULL), caster_ptr->fy, caster_ptr->fx, summon_lev, SUMMON_HI_UNDEAD, (g_mode | p_mode | PM_ALLOW_UNIQUE)))
			{
				count++;
				if (!pet)
#ifdef JP
msg_print("ꂽ㋉Afbh͓{ĂI");
#else
msg_print("Summoned greater undeads are angry!");
#endif
			}
		if (!count)
		{
			no_trump = TRUE;
		}
		break;
	}
	default:
		msg_print("hoge?");
	}
	if (no_trump)
	{
#ifdef JP
msg_print("ȂB");
#else
msg_print("No one have appeared.");
#endif
	}

	return TRUE;
}


/*
 * do_cmd_cast calls this function if the player's class
 * is 'Blue-Mage'.
 */
bool do_cmd_cast_learned(creature_type *creature_ptr)
{
	int             n = 0;
	int             chance;
	int             minfail = 0;
	int             plev = creature_ptr->lev;
	racial_power   spell;
	bool            cast;
	int             need_mana;


	/* not if confused */
	if (creature_ptr->confused)
	{
#ifdef JP
msg_print("ĂďȂI");
#else
		msg_print("You are too confused!");
#endif

		return TRUE;
	}

	/* get power */
	if (!get_learned_power(creature_ptr, &n)) return FALSE;

	spell = racial_powers[n];

	need_mana = mod_need_mana(creature_ptr, spell.smana, 0, REALM_NONE);

	/* Verify "dangerous" spells */
	if (need_mana > creature_ptr->csp)
	{
		/* Warning */
#ifdef JP
msg_print("lo܂B");
#else
		msg_print("You do not have enough mana to use this power.");
#endif


		if (!over_exert) return FALSE;

		/* Verify */
#ifdef JP
if (!get_check("ł킵܂? ")) return FALSE;
#else
		if (!get_check("Attempt it anyway? ")) return FALSE;
#endif

	}

	/* Spell failure chance */
	chance = spell.fail;

	/* Reduce failure rate by "effective" level adjustment */
	if (plev > spell.level) chance -= 3 * (plev - spell.level);
	else chance += (spell.level - plev);

	/* Reduce failure rate by INT/WIS adjustment */
	chance -= 3 * (adj_mag_stat[creature_ptr->stat_ind[STAT_INT]] - 1);

	chance = mod_spell_chance_1(creature_ptr, chance);

	/* Not enough mana to cast */
	if (need_mana > creature_ptr->csp)
	{
		chance += 5 * (need_mana - creature_ptr->csp);
	}

	/* Extract the minimum failure rate */
	minfail = adj_mag_fail[creature_ptr->stat_ind[STAT_INT]];

	/* Minimum failure rate */
	if (chance < minfail) chance = minfail;

	/* Stunning makes spells harder */
	if (creature_ptr->stun > 50) chance += 25;
	else if (creature_ptr->stun) chance += 15;

	/* Always a 5 percent chance of working */
	if (chance > 95) chance = 95;

	chance = mod_spell_chance_2(creature_ptr, chance);

	/* Failed spell */
	if (randint0(100) < chance)
	{
		if (flush_failure) flush();
#ifdef JP
msg_print("@܂ȂB");
#else
		msg_print("You failed to concentrate hard enough!");
#endif

		sound(SOUND_FAIL);

		if (n >= MS_S_KIN)
			/* Cast the spell */
			cast = cast_learned_spell(creature_ptr, n, FALSE);
	}
	else
	{
		sound(SOUND_ZAP);

		/* Cast the spell */
		cast = cast_learned_spell(creature_ptr, n, TRUE);

		if (!cast) return FALSE;
	}

	/* Sufficient mana */
	if (need_mana <= creature_ptr->csp)
	{
		/* Use some mana */
		creature_ptr->csp -= need_mana;
	}
	else
	{
		int oops = need_mana;

		/* No mana left */
		creature_ptr->csp = 0;
		creature_ptr->csp_frac = 0;

		/* Message */
#ifdef JP
msg_print("_WċCĂ܂I");
#else
		msg_print("You faint from the effort!");
#endif


		/* Hack -- Bypass free action */
		(void)set_paralyzed(creature_ptr, creature_ptr->paralyzed + randint1(5 * oops + 1));

		/* Damage CON (possibly permanently) */
		if (randint0(100) < 50)
		{
			bool perm = (randint0(100) < 25);

			/* Message */
#ifdef JP
msg_print("̂Ă܂I");
#else
			msg_print("You have damaged your health!");
#endif


			/* Reduce constitution */
			(void)dec_stat(creature_ptr, STAT_CON, 15 + randint1(10), perm);
		}
	}

	/* Take a turn */
	energy_use = 100;

	/* Window stuff */
	play_redraw |= (PR_MANA);
	play_window |= (PW_PLAYER);
	play_window |= (PW_SPELL);

	return TRUE;
}

void learn_spell(creature_type *creature_ptr, int monspell)
{
	if (creature_ptr->action != ACTION_LEARN) return;
	if (monspell < 0) return; /* Paranoia */
	if (creature_ptr->magic_num2[monspell]) return;
	if (creature_ptr->confused || IS_BLIND(creature_ptr) || IS_HALLUCINATION(creature_ptr) || creature_ptr->stun || creature_ptr->paralyzed) return;
	if (randint1(creature_ptr->lev + 70) > racial_powers[monspell].level + 40)
	{
		creature_ptr->magic_num2[monspell] = 1;
#ifdef JP
		msg_format("%swKI", racial_powers[monspell].name);
#else
		msg_format("You have learned %s!", racial_powers[monspell].name);
#endif
		gain_exp(creature_ptr, racial_powers[monspell].level * racial_powers[monspell].smana);

		/* Sound */
		sound(SOUND_STUDY);

		new_mane = TRUE;
		play_redraw |= (PR_STATE);
	}
}


/*
 * Extract creature spells mask for the given mode
 */
void set_rf_masks(s32b *f4, s32b *f5, s32b *f6, int mode)
{
		/*
	switch (mode)
	{
		case MONSPELL_TYPE_BOLT:
			*f4 = ((BOLT_MASK | BEAM_MASK) & ~(ROCKET));
			*f5 = BOLT_MASK | BEAM_MASK;
			*f6 = BOLT_MASK | BEAM_MASK;
			break;

		case MONSPELL_TYPE_BALL:
			*f4 = (BALL_MASK & ~(BREATH_MASK));
			*f5 = (BALL_MASK & ~(BREATH_MASK));
			*f6 = (BALL_MASK & ~(BREATH_MASK));
			break;

		case MONSPELL_TYPE_BREATH:
			*f4 = BREATH_MASK;
			*f5 = BREATH_MASK;
			*f6 = BREATH_MASK;
			break;

		case MONSPELL_TYPE_SUMMON:
			*f4 = SUMMON_MASK;
			*f5 = SUMMON_MASK;
			*f6 = SUMMON_MASK;
			break;

		case MONSPELL_TYPE_OTHER:
			*f4 = ATTACK_MASK & ~(BOLT_MASK | BEAM_MASK | BALL_MASK | INDIRECT_MASK);
			*f5 = ATTACK_MASK & ~(BOLT_MASK | BEAM_MASK | BALL_MASK | INDIRECT_MASK);
			*f6 = ATTACK_MASK & ~(BOLT_MASK | BEAM_MASK | BALL_MASK | INDIRECT_MASK);
			break;
	}
		*/

	return;
}
