/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.io.serial.port;

import com.romraider.io.serial.port.SerialPortDiscoverer;
import com.romraider.io.serial.port.SerialPortDiscovererImpl;
import com.romraider.io.serial.port.SerialPortRefreshListener;
import com.romraider.util.ParamChecker;
import com.romraider.util.ThreadUtil;
import gnu.io.CommPortIdentifier;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerialPortRefresher
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(SerialPortRefresher.class);
    private static final long PORT_REFRESH_INTERVAL = 15000L;
    private final SerialPortDiscoverer serialPortDiscoverer = new SerialPortDiscovererImpl();
    private final SerialPortRefreshListener listener;
    private final String defaultLoggerPort;
    private boolean started;

    public SerialPortRefresher(SerialPortRefreshListener serialPortRefreshListener, String string) {
        ParamChecker.checkNotNull(serialPortRefreshListener);
        this.listener = serialPortRefreshListener;
        this.defaultLoggerPort = string;
    }

    @Override
    public void run() {
        this.refreshPortList();
        this.started = true;
        while (true) {
            ThreadUtil.sleep(15000L);
            this.refreshPortList();
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private void refreshPortList() {
        try {
            this.listener.refreshPortList(this.listSerialPorts(), this.defaultLoggerPort);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Error refreshing serial ports", (Throwable)exception);
        }
    }

    private Set<String> listSerialPorts() {
        List<CommPortIdentifier> list = this.serialPortDiscoverer.listPorts();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (CommPortIdentifier commPortIdentifier : list) {
            String string = commPortIdentifier.getName();
            if (treeSet.contains(string)) continue;
            treeSet.add(string);
        }
        return treeSet;
    }
}

