/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.external;

import com.romraider.logger.ecu.definition.plugin.PluginFilenameFilter;
import com.romraider.logger.ecu.exception.ConfigurationException;
import com.romraider.logger.ecu.external.ExternalDataSource;
import com.romraider.logger.ecu.external.ExternalDataSourceLoader;
import com.romraider.logger.ecu.external.GenericDataSourceManager;
import com.romraider.util.ParamChecker;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExternalDataSourceLoaderImpl
implements ExternalDataSourceLoader {
    private static final Logger LOGGER = Logger.getLogger(ExternalDataSourceLoaderImpl.class);
    private List<ExternalDataSource> externalDataSources = new ArrayList<ExternalDataSource>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadExternalDataSources() {
        try {
            File file = new File("./plugins");
            if (file.exists() && file.isDirectory()) {
                File[] fileArray;
                this.externalDataSources = new ArrayList<ExternalDataSource>();
                for (File file2 : fileArray = file.listFiles(new PluginFilenameFilter())) {
                    Properties properties = new Properties();
                    FileInputStream fileInputStream = new FileInputStream(file2);
                    try {
                        properties.load(fileInputStream);
                        String string = properties.getProperty("datasource.class");
                        if (ParamChecker.isNullOrEmpty(string)) continue;
                        try {
                            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
                            if (clazz == null || !ExternalDataSource.class.isAssignableFrom(clazz)) continue;
                            ExternalDataSource externalDataSource = (ExternalDataSource)clazz.newInstance();
                            GenericDataSourceManager genericDataSourceManager = new GenericDataSourceManager(externalDataSource);
                            this.externalDataSources.add(genericDataSourceManager);
                            LOGGER.info((Object)("Plugin loaded: " + externalDataSource.getName() + " v" + externalDataSource.getVersion()));
                        }
                        catch (Throwable throwable) {
                            LOGGER.error((Object)("Error loading external datasource: " + string + ", specified in: " + file2.getAbsolutePath()), throwable);
                        }
                    }
                    finally {
                        fileInputStream.close();
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException(exception);
        }
    }

    @Override
    public List<ExternalDataSource> getExternalDataSources() {
        return this.externalDataSources;
    }
}

