/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.handler.injector;

import com.romraider.logger.ecu.comms.query.Response;
import com.romraider.logger.ecu.definition.LoggerData;
import com.romraider.logger.ecu.ui.handler.DataUpdateHandler;
import com.romraider.logger.ecu.ui.tab.injector.InjectorTab;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class InjectorUpdateHandler
implements DataUpdateHandler {
    private static final Logger LOGGER = Logger.getLogger(InjectorUpdateHandler.class);
    private static final String PULSE_WIDTH_16 = "E28";
    private static final String PULSE_WIDTH_32 = "E60";
    private static final String ENGINE_LOAD_16 = "E2";
    private static final String ENGINE_LOAD_32 = "E32";
    private InjectorTab injectorTab;
    private double lastMafv;
    private long lastUpdate;

    public synchronized void registerData(LoggerData loggerData) {
    }

    public synchronized void handleDataUpdate(Response response) {
        if (this.injectorTab.isRecordData() && (this.containsData(response, PULSE_WIDTH_16, ENGINE_LOAD_16) || this.containsData(response, PULSE_WIDTH_32, ENGINE_LOAD_32))) {
            double d;
            double d2;
            boolean bl = true;
            if (this.containsData(response, "E3") || this.containsData(response, "E33")) {
                d2 = -1.0;
                if (this.containsData(response, "E3")) {
                    d2 = (int)this.findValue(response, "E3");
                    LOGGER.trace((Object)("INJ:[CL/OL:E3]:  " + d2));
                }
                if (this.containsData(response, "E33")) {
                    d2 = (int)this.findValue(response, "E33");
                    LOGGER.trace((Object)("INJ:[CL/OL:E33]: " + d2));
                }
                bl = this.injectorTab.isValidClOl(d2);
                LOGGER.trace((Object)("INJ:[CL/OL]:     " + bl));
            }
            if (bl && this.containsData(response, "P58")) {
                d2 = this.findValue(response, "P58");
                LOGGER.trace((Object)("INJ:[AFR:P58]: " + d2));
                bl = this.injectorTab.isValidAfr(d2);
                LOGGER.trace((Object)("INJ:[AFR]:     " + bl));
            }
            if (bl && this.containsData(response, "P8")) {
                d2 = this.findValue(response, "P8");
                LOGGER.trace((Object)("INJ:[RPM:P8]: " + d2));
                bl = this.injectorTab.isValidRpm(d2);
                LOGGER.trace((Object)("INJ:[RPM]:    " + bl));
            }
            if (bl && this.containsData(response, "P12")) {
                d2 = this.findValue(response, "P12");
                LOGGER.trace((Object)("INJ:[MAF:P12]: " + d2));
                bl = this.injectorTab.isValidMaf(d2);
                LOGGER.trace((Object)("INJ:[MAF]:     " + bl));
            }
            if (bl && this.containsData(response, "P11")) {
                d2 = this.findValue(response, "P11");
                LOGGER.trace((Object)("INJ:[IAT:P11]: " + d2));
                bl = this.injectorTab.isValidIntakeAirTemp(d2);
                LOGGER.trace((Object)("INJ:[IAT]:     " + bl));
            }
            if (bl && this.containsData(response, "P2")) {
                d2 = this.findValue(response, "P2");
                LOGGER.trace((Object)("INJ:[CT:P2]: " + d2));
                bl = this.injectorTab.isValidCoolantTemp(d2);
                LOGGER.trace((Object)("INJ:[CT]:    " + bl));
            }
            if (bl && this.containsData(response, "P18")) {
                d2 = this.findValue(response, "P18");
                long l = System.currentTimeMillis();
                d = Math.abs((d2 - this.lastMafv) / (double)(l - this.lastUpdate) * 1000.0);
                LOGGER.trace((Object)("INJ:[dMAFv/dt]: " + d));
                bl = this.injectorTab.isValidMafvChange(d);
                LOGGER.trace((Object)("INJ:[dMAFv/dt]: " + bl));
                this.lastMafv = d2;
                this.lastUpdate = l;
            }
            if (bl && (this.containsData(response, "E23") || this.containsData(response, "E54"))) {
                d2 = -1.0;
                if (this.containsData(response, "E23")) {
                    d2 = this.findValue(response, "E23");
                    LOGGER.trace((Object)("INJ:[TIP:E23]: " + d2));
                }
                if (this.containsData(response, "E54")) {
                    d2 = this.findValue(response, "E54");
                    LOGGER.trace((Object)("INJ:[TIP:E54]: " + d2));
                }
                bl = this.injectorTab.isValidTipInThrottle(d2);
                LOGGER.trace((Object)("INJ:[TIP]:     " + bl));
            }
            if (bl) {
                d2 = this.containsData(response, PULSE_WIDTH_16) ? this.findValue(response, PULSE_WIDTH_16) : this.findValue(response, PULSE_WIDTH_32);
                double d3 = this.containsData(response, ENGINE_LOAD_16) ? this.findValue(response, ENGINE_LOAD_16) : this.findValue(response, ENGINE_LOAD_32);
                d = this.injectorTab.getFuelStoichAfr();
                double d4 = this.injectorTab.getFuelDensity();
                final double d5 = d3 / 2.0 / d * 1000.0 / d4;
                LOGGER.trace((Object)("Injector Data: " + d2 + "ms, " + d5 + "cc"));
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        InjectorUpdateHandler.this.injectorTab.addData(d2, d5);
                    }
                });
            }
        }
    }

    private boolean containsData(Response response, String ... stringArray) {
        Set<LoggerData> set = response.getData();
        for (String string : stringArray) {
            boolean bl = false;
            for (LoggerData loggerData : set) {
                if (!loggerData.getId().equals(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private double findValue(Response response, String string) {
        for (LoggerData loggerData : response.getData()) {
            if (!string.equals(loggerData.getId())) continue;
            return response.getDataValue(loggerData);
        }
        throw new IllegalStateException("Expected data item " + string + " not in response.");
    }

    public synchronized void deregisterData(LoggerData loggerData) {
    }

    public synchronized void cleanUp() {
    }

    public synchronized void reset() {
    }

    public void setInjectorTab(InjectorTab injectorTab) {
        this.injectorTab = injectorTab;
    }
}

