/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.logger.ecu.ui.swing.menubar.action;

import com.romraider.logger.ecu.EcuLogger;
import com.romraider.logger.ecu.ui.swing.menubar.action.AbstractAction;
import com.romraider.logger.ecu.ui.swing.menubar.util.FileHelper;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;

public final class LoggerDefinitionLocationAction
extends AbstractAction {
    public LoggerDefinitionLocationAction(EcuLogger ecuLogger) {
        super(ecuLogger);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.setDefinitionLocationDialog();
            this.logger.loadLoggerParams();
        }
        catch (Exception exception) {
            this.logger.reportError(exception);
        }
    }

    private void setDefinitionLocationDialog() throws Exception {
        File file = FileHelper.getFile(this.logger.getSettings().getLoggerDefinitionFilePath());
        JFileChooser jFileChooser = FileHelper.getDefinitionFileChooser(file);
        if (jFileChooser.showOpenDialog(this.logger) == 0) {
            String string = jFileChooser.getSelectedFile().getAbsolutePath();
            this.logger.getSettings().setLoggerDefinitionFilePath(string);
            this.logger.reportMessage("Logger definition location successfully updated: " + string);
        }
    }
}

