/*
 * Decompiled with CFR 0.152.
 */
package com.romraider.maps;

import com.romraider.Settings;
import com.romraider.maps.DataCell;
import com.romraider.maps.Scale;
import com.romraider.maps.Table;
import com.romraider.maps.Table1D;
import com.romraider.swing.TableFrame;
import com.romraider.util.AxisRange;
import com.romraider.util.ParamChecker;
import com.romraider.util.TableAxisUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JLabel;

public class Table2D
extends Table {
    private static final long serialVersionUID = -7684570967109324784L;
    private static final String NEW_LINE = System.getProperty("line.separator");
    private Table1D axis = new Table1D(new Settings());

    public Table2D(Settings settings) {
        super(settings);
        this.verticalOverhead += 18;
    }

    public Table1D getAxis() {
        return this.axis;
    }

    public void setAxis(Table1D table1D) {
        this.axis = table1D;
    }

    public String toString() {
        return super.toString() + " (2D)";
    }

    public void colorize() {
        super.colorize();
        this.axis.colorize();
    }

    public void setFrame(TableFrame tableFrame) {
        this.frame = tableFrame;
        this.axis.setFrame(tableFrame);
        tableFrame.setSize(this.getFrameSize());
    }

    public Dimension getFrameSize() {
        int n;
        int n2 = this.verticalOverhead + this.cellHeight * 2;
        int n3 = this.horizontalOverhead + this.data.length * this.cellWidth;
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        }
        int n4 = n = this.isLiveDataSupported() ? this.minWidthOverlay : this.minWidthNoOverlay;
        if (n3 < n) {
            n3 = n;
        }
        return new Dimension(n3, n2);
    }

    public void applyColorSettings(Settings settings) {
        this.setAxisColor(settings.getAxisColor());
        this.axis.applyColorSettings(settings);
        super.applyColorSettings(settings);
    }

    public void populateTable(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        int n;
        this.centerLayout.setRows(2);
        this.centerLayout.setColumns(this.getDataSize());
        try {
            this.axis.setRom(this.container);
            this.axis.populateTable(byArray);
            super.populateTable(byArray);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (n = 0; n < this.getDataSize(); ++n) {
            this.centerPanel.add(this.axis.getDataCell(n));
        }
        if (this.flip) {
            for (n = this.getDataSize() - 1; n >= 0; --n) {
                this.centerPanel.add(this.getDataCell(n));
            }
        } else {
            for (n = 0; n < this.getDataSize(); ++n) {
                this.centerPanel.add(this.getDataCell(n));
            }
        }
        this.add((Component)new JLabel(this.axis.getName() + " (" + this.axis.getScale().getUnit() + ")", 0), "North");
        if (this.axis.isStatic()) {
            this.add((Component)new JLabel(this.axis.getName(), 0), "North");
        } else {
            this.add((Component)new JLabel(this.axis.getName() + " (" + this.axis.getScale().getUnit() + ")", 0), "North");
        }
        this.add((Component)new JLabel(((Scale)this.scales.get(this.scaleIndex)).getUnit(), 0), "South");
    }

    public void increment(double d) {
        super.increment(d);
        this.axis.increment(d);
    }

    public void multiply(double d) {
        super.multiply(d);
        this.axis.multiply(d);
    }

    public void clearSelection() {
        this.axis.clearSelection(true);
        for (DataCell dataCell : this.data) {
            dataCell.setSelected(false);
        }
    }

    public void setRevertPoint() {
        super.setRevertPoint();
        this.axis.setRevertPoint();
    }

    public void undoAll() {
        super.undoAll();
        this.axis.undoAll();
    }

    public void undoSelected() {
        super.undoSelected();
        this.axis.undoSelected();
    }

    public byte[] saveFile(byte[] byArray) {
        byArray = super.saveFile(byArray);
        byArray = this.axis.saveFile(byArray);
        return byArray;
    }

    public void setRealValue(String string) {
        this.axis.setRealValue(string);
        super.setRealValue(string);
    }

    public void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.axis.addKeyListener(keyListener);
    }

    public void selectCellAt(int n, Table1D table1D) {
        this.selectCellAt(n);
    }

    public void cursorUp() {
        if (!this.axis.isStatic() && this.data[this.highlightY].isSelected().booleanValue()) {
            this.axis.selectCellAt(this.highlightY);
        }
    }

    public void cursorDown() {
        this.axis.cursorDown();
    }

    public void cursorLeft() {
        if (this.highlightY > 0 && this.data[this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightY - 1);
        } else {
            this.axis.cursorLeft();
        }
    }

    public void cursorRight() {
        if (this.highlightY < this.data.length - 1 && this.data[this.highlightY].isSelected().booleanValue()) {
            this.selectCellAt(this.highlightY + 1);
        } else {
            this.axis.cursorRight();
        }
    }

    public void startHighlight(int n, int n2) {
        this.axis.clearSelection();
        super.startHighlight(n, n2);
    }

    public void copySelection() {
        super.copySelection();
        this.axis.copySelection();
    }

    public void copyTable() {
        StringBuffer stringBuffer = new StringBuffer("[Table2D]" + NEW_LINE);
        stringBuffer.append(this.axis.getTableAsString()).append(NEW_LINE);
        stringBuffer.append(super.getTableAsString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuffer.toString()), null);
    }

    public void paste() {
        StringTokenizer stringTokenizer = new StringTokenizer("");
        String string = "";
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("[Table2D]")) {
            String string3 = "[Table1D]" + NEW_LINE + stringTokenizer.nextToken(NEW_LINE);
            String string4 = "[Table1D]" + NEW_LINE + stringTokenizer.nextToken(NEW_LINE);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string3), null);
            this.axis.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string4), null);
            super.paste();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        } else if (string2.equalsIgnoreCase("[Selection1D]")) {
            if (this.data[this.highlightY].isSelected().booleanValue()) {
                super.paste();
            } else {
                this.axis.paste();
            }
        }
        this.colorize();
    }

    public void pasteCompare() {
        StringTokenizer stringTokenizer = new StringTokenizer("");
        String string = "";
        try {
            string = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null).getTransferData(DataFlavor.stringFlavor);
            stringTokenizer = new StringTokenizer(string);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equalsIgnoreCase("[Table2D]")) {
            String string3 = "[Table1D]" + NEW_LINE + stringTokenizer.nextToken(NEW_LINE);
            String string4 = "[Table1D]" + NEW_LINE + stringTokenizer.nextToken(NEW_LINE);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string3), null);
            this.axis.pasteCompare();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string4), null);
            super.pasteCompare();
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), null);
        }
    }

    public void setAxisColor(Color color) {
        this.axis.setAxisColor(color);
    }

    public void validateScaling() {
        super.validateScaling();
        this.axis.validateScaling();
    }

    public void setScaleIndex(int n) {
        super.setScaleIndex(n);
        this.axis.setScaleByName(this.getScale().getName());
    }

    public boolean isLiveDataSupported() {
        return !ParamChecker.isNullOrEmpty(this.axis.getLogParam());
    }

    protected void highlightLiveData() {
        if (this.overlayLog && this.frame.isVisible()) {
            AxisRange axisRange = TableAxisUtil.getLiveDataRangeForAxis(this.axis);
            this.clearSelection();
            boolean bl = true;
            for (int i = axisRange.getStartIndex(); i <= axisRange.getEndIndex(); ++i) {
                int n = 0;
                int n2 = i;
                if (this.axis.getType() == 4) {
                    n = i;
                    n2 = 0;
                }
                if (bl) {
                    this.startHighlight(n, n2);
                    bl = false;
                } else {
                    this.highlight(n, n2);
                }
                DataCell dataCell = this.data[i];
                dataCell.setLiveDataTrace(true);
                dataCell.setDisplayValue(dataCell.getRealValue() + (ParamChecker.isNullOrEmpty(this.liveValue) ? "" : ':' + this.liveValue));
            }
            this.stopHighlight();
            this.frame.getToolBar().setLiveDataValue(this.liveValue);
        }
    }

    public void clearLiveDataTrace() {
        for (DataCell dataCell : this.data) {
            dataCell.setLiveDataTrace(false);
            dataCell.updateDisplayValue();
        }
    }
}

