//  Copyright (c) 2009 Yanagi Asakura
//
//  This software is provided 'as-is', without any express or implied
//  warranty. In no event will the authors be held liable for any damages
//  arising from the use of this software.
//
//  Permission is granted to anyone to use this software for any purpose,
//  including commercial applications, and to alter it and redistribute it
//  freely, subject to the following restrictions:
//
//  1. The origin of this software must not be misrepresented; you must not
//  claim that you wrote the original software. If you use this software
//  in a product, an acknowledgment in the product documentation would be
//  appreciated but is not required.
//
//  2. Altered source versions must be plainly marked as such, and must not be
//  misrepresented as being the original software.
//
//  3. This notice may not be removed or altered from any source
//  distribution.

//
//  ElisMedia.h
//  Elis Colors
//
//  Created by 柳 on 09/09/12.
//  Copyright 2009 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import "ElisBase.h"

@interface ElisMedia : NSObject {
    QTMovie* movie;  // for Movie and Quartz Composer
    CIImage* image;  // for Image
    QTMovie* sound;  // for Audio
    NSAttributedString* text;  // for Text Layer
    NSDictionary* attr;  // for Movie and Quartz Composer
    float speed;  // for Movie    1.0 = 等速, 2.0 = 倍速
    NSString* _path;  // for 全部
    BOOL playing; // for Audio    再生中かどうか
    QTVisualContextRef textureContext;
    BOOL isQuartz;
}

- (QTTime)duration;
- (id)initWithMovieFile:(NSString*)path;
- (void)play;
- (void)stop;
- (CIImage*)getFrameForTime:(CVTimeStamp*)timeStamp;
- (void)releaseContext;
- (NSString*)type;
- (NSAttributedString*)text;
- (NSRect)size;
- (float)speed;
- (void)setSpeed:(float)s;
- (void)setVolume:(float)v;

@end
